/**
 * Created by willian batista on 16/02/17.
 */

var Comprador = function() {
    this.mapper = mapperFactory.createMapperMult(["EstComprador", "EstProdAgendaCompra"]);
};

/**
 * Metodo válida os dados passados pelo requisição
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @param {Objeto JS} metodo - descrição do metodo HTTP da requisição
 * @throws {InvalidArgumentException} caso o usuario definido como comprador já esteja vinculado em outro cadastro
 */
Comprador.prototype.validarDados = function(json, metodo){
	if(metodo == 'POST'){
		var retorno = this.mapper.selectList('EstComprador.listarEstComprador', {"cdUsuComprador": json.get('cdUsuComprador')});
		if(retorno.size()>0)
		throw {code: 599, message: "Usuário já está definido em outro cadastro de comprador!"};
	}
		
	if(metodo == 'PUT'){
		var retorno = this.mapper.selectList('EstComprador.listarEstComprador', {"cdUsuComprador": json.get('cdUsuComprador'), 'cdComprador': json.get('cdComprador'), 'invert':true});
		if(retorno.size() > 0)
			throw {code: 599, message: "Usuário já está definido em outro cadastro de comprador!"};	
	}
	
	if(metodo == 'DELETE'){
		var retorno = this.mapper.selectList('EstProdAgendaCompra.listarEstProdAgendaCompra', {'cdComprador': json.get('cdComprador')});
		if(retorno.size() > 0)
			throw {code: 599, message: "Comprador vinculado a agenda de compra!"};	
	}
		
};

/**
 * Metodo realiza insert na tabela EST_COMPRADOR
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
Comprador.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	this.validarDados(json, 'POST');
	
	try{
		this.mapper.insert('EstComprador.incluirEstComprador', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};


/**
 * Metodo realiza alteração na tabela EST_COMPRADOR
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
Comprador.prototype.put = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	this.validarDados(json, 'PUT');
	
	try{
		this.mapper.update('EstComprador.alterarEstComprador', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};



/**
 * Metodo exclui registro da tabela EST_COMPRADOR
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
Comprador.prototype.del = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	this.validarDados(json, 'DELETE');
	
	try{
		this.mapper.update('EstComprador.excluirEstComprador', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};