var Alcada = function () {
    this.mapper = mapperFactory.createMapperMult(["EstProdCplFaceAgenda", "EstProdCplFaceAgendaEstProd"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

Alcada.prototype.detalheAlcada = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        var pegarCdAgd = this.mapper.selectList('EstProdCplFaceAgendaEstProd.ufdEstAlcadaCpPedSts', {cdEmp:obj.get("cdEmp"), cdCtr: obj.get("cdCtr")});
       // println("pegarCdAgd----  "+ pegarCdAgd.get(0).get("cdAgd"));
        var objFaceAgenda = {
            cdEmp: 1,
            cdAgd: pegarCdAgd.get(0).get("cdAgd")
        }

        var faceAgendamento = this.mapper.selectList('EstProdCplFaceAgenda.listarEstProdCplFaceAgenda', objFaceAgenda);
        var produtos = this.mapper.selectList('EstProdCplFaceAgendaEstProd.listarProdutosAgendamento', objFaceAgenda);

        var retorno = {
            header: faceAgendamento,
            produtos: produtos
        };
        
        this.mapper.commit();
        return retorno;
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }

};