/**
 * Created by victor vieira garcia on 25/05/2017.
 */
load('/model/compras/AgendaDeCompra.js');
var Agendamento = function () {
    this.mapper = mapperFactory.createMapperMult(["EstProdCplFaceAgenda", "EstProdCplFaceAgendaEstProd",
        "EstAlcadaCpPed", "EstAlcadaCp", "EstAlcadaCpPedAlcadas", "EstAlcadaCpPedAlcadasLib", "EstAlcadaCpPedEstProdCplFaceAgenda"
    ]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
    this.agendaDeCompra = new AgendaDeCompra();
};


Agendamento.prototype.incluirEstProdCplFaceAgendaEstProd = function(agendamento){
    let param = {
        'arr': [],
        'cdAgd': agendamento.get('cdAgd')
    };
    let numMarkers = 0;

    for(let i = 0; i < agendamento.get('arr').size(); i++){
        let item = agendamento.get('arr').get(i);
        if((numMarkers + 12) > 2000){
            this.mapper.insert('EstProdCplFaceAgendaEstProd.incluirEstProdCplFaceAgendaEstProd', param);
            param.arr = [];
            numMarkers = 0;
            i --;
        }else{
            param.arr.push(item);
            numMarkers = numMarkers + 12;
        }
    }

    if(param.arr.length > 0)
        this.mapper.insert('EstProdCplFaceAgendaEstProd.incluirEstProdCplFaceAgendaEstProd', param);
};

/**
 * Metodo cadastra agendamento,e liberação de alcada se alcada for maior que litime alcada,
 *  e se o tipo faceamento financiamento diferente de 2
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */

Agendamento.prototype.cadastroAgendamentoAlcada = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        if (obj.get(0).get("agendamento").get(0).get("dsUsualAlcada")) {
            var dsAgd = obj.get(0).get("agendamento").get(0).get("dsUsualAlcada");
        } else {
            var dsAgd = 'FACEAMENTO, USUÁRIO: ' + obj.get(0).get("agendamento").get(0).get("cdUsu");
        }

        
        var flagAgendamentoArray = new java.util.ArrayList();
        var flagAlcadaArray = new java.util.ArrayList();
        var dataFormatada = new java.text.SimpleDateFormat("yyyy/MM/dd").format(new java.util.Date());

        var objSalvarFaceAgenda = mapperFactory.createMap();
        objSalvarFaceAgenda.put("cdEmp", obj.get(0).get("agendamento").get(0).get("cdEmp"));
        objSalvarFaceAgenda.put("dsAgd", dsAgd);
        objSalvarFaceAgenda.put("cdUsu", obj.get(0).get("agendamento").get(0).get("cdUsu"));
        objSalvarFaceAgenda.put("dtAgd", dataFormatada);
        objSalvarFaceAgenda.put("tpFaceFin", obj.get(0).get("agendamento").get(0).get("tpFaceFin"));
        objSalvarFaceAgenda.put("stsAgd", 0);

        if (obj.get(0).get("agendamento").get(0).get("tpFaceFin") != 2) {
            for (var i = 0; i < obj.get(0).get("agendamento").size(); i++) {
                if (obj.get(0).get("agendamento").get(i).get("qtdeFaceamento") > obj.get(0).get("agendamento").get(i).get("limiteFace")) {
                    flagAlcadaArray.add(obj.get(0).get("agendamento").get(i));
                } else {
                    flagAgendamentoArray.add(obj.get(0).get("agendamento").get(i));
                }
            }
        }

        if (obj.get(0).get("agendamento").get(0).get("tpFaceFin") == 2) {
        	
            this.mapper.insert('EstProdCplFaceAgenda.incluirEstProdCplFaceAgenda', objSalvarFaceAgenda);

            var agenObjSalvarFaceAgendaProd = mapperFactory.createMap();
            agenObjSalvarFaceAgendaProd.put("arr", obj.get(0).get("agendamento"));
            agenObjSalvarFaceAgendaProd.put("cdAgd", objSalvarFaceAgenda.get("cdAgd"));

            this.incluirEstProdCplFaceAgendaEstProd(agenObjSalvarFaceAgendaProd);
            this.mapper.selectOne('EstProdCplFaceAgenda.pEstProdCplFaceAgenda', {});
        }

        if (flagAgendamentoArray.size() > 0) {

            this.mapper.insert('EstProdCplFaceAgenda.incluirEstProdCplFaceAgenda', objSalvarFaceAgenda);

            var agenObjSalvarFaceAgendaProd = mapperFactory.createMap();
            agenObjSalvarFaceAgendaProd.put("arr", flagAgendamentoArray);
            agenObjSalvarFaceAgendaProd.put("cdAgd", objSalvarFaceAgenda.get("cdAgd"));

            this.incluirEstProdCplFaceAgendaEstProd(agenObjSalvarFaceAgendaProd);
            this.mapper.selectOne('EstProdCplFaceAgenda.pEstProdCplFaceAgenda', {});
        }

        if (flagAlcadaArray.size() > 0) {
            objSalvarFaceAgenda.put("stsAgd", 2);
        
            this.mapper.insert('EstProdCplFaceAgenda.incluirEstProdCplFaceAgenda', objSalvarFaceAgenda);

            var objSalvarFaceAgendaProd = mapperFactory.createMap();
            objSalvarFaceAgendaProd.put("arr", flagAlcadaArray);
            objSalvarFaceAgendaProd.put("cdAgd", objSalvarFaceAgenda.get("cdAgd"));

            this.incluirEstProdCplFaceAgendaEstProd(objSalvarFaceAgendaProd);

            if (obj.get(0).get("agendamento").get(0).get("obsAlcada")) {
                var obsAlcada = obj.get(0).get("agendamento").get(0).get("obsAlcada");
            } else {
                var obsAlcada = "SEM OBSERVAÇÃO";
            }

            var objSalvarEstAlcadaCpPed = mapperFactory.createMap();
            objSalvarEstAlcadaCpPed.put("dsUsualAlcada", dsAgd);
            objSalvarEstAlcadaCpPed.put("obsAlcada", obsAlcada);
            objSalvarEstAlcadaCpPed.put("cdEmp", obj.get(0).get("agendamento").get(0).get("cdEmp"));
            objSalvarEstAlcadaCpPed.put("tpAlcada", obj.get(0).get("agendamento").get(0).get("tpAlcada"));
            objSalvarEstAlcadaCpPed.put("tpEventoAlcada", obj.get(0).get("agendamento").get(0).get("tpEventoAlcada"));
            objSalvarEstAlcadaCpPed.put("cdUsu", obj.get(0).get("agendamento").get(0).get("cdUsu"));

            this.mapper.insert('EstAlcadaCpPed.incluirEstAlcadaCpPed', objSalvarEstAlcadaCpPed);

            this.mapper.insert('EstAlcadaCpPedEstProdCplFaceAgenda.incluirEstAlcadaCpPedEstProdCplFaceAgenda', {
                cdCtr: objSalvarEstAlcadaCpPed.get("cdCtr"),
                cdEmp: objSalvarEstAlcadaCpPed.get("cdEmp"),
                cdAgd: objSalvarFaceAgenda.get("cdAgd")
            });

            var listaDeUsuarioPossiveisParaLiberacaoDeAlcada = this.mapper.selectList('EstAlcadaCp.usuarioParaLiberacaoDeAlcada', {
                cdUsu: obj.get(0).get("agendamento").get(0).get("cdUsu")
            });

            if (listaDeUsuarioPossiveisParaLiberacaoDeAlcada.size() > 0) {
                var contador = 0;
                for (var i = 0; i < listaDeUsuarioPossiveisParaLiberacaoDeAlcada.size(); i++) {
                		let usuarioParaLiberacao = listaDeUsuarioPossiveisParaLiberacaoDeAlcada.get(i);
                    contador = contador + 1;

                    var objSalvarToken = mapperFactory.createMap();
                    for(var j = 0; j<usuarioParaLiberacao.get('gruposDeLiberacao').size(); j++){
                    	 let grupoDeLiberacao = usuarioParaLiberacao.get('gruposDeLiberacao').get(j);
                    	 if(objSalvarToken.get('cdGrpUsu') == null || (objSalvarToken.get("percAlcada") < grupoDeLiberacao.get('percAlcada'))){
                    		 objSalvarToken.put("cdGrpUsu", grupoDeLiberacao.get("cdGrp"));
                      	 objSalvarToken.put("hrSla", grupoDeLiberacao.get("hrSla"));
                         objSalvarToken.put("cdAlcada", grupoDeLiberacao.get("cdAlcada"));
                         objSalvarToken.put("percAlcada", grupoDeLiberacao.get("percAlcada"));
                    	 } 
                    }
                    
                    objSalvarToken.put("cdCtr", objSalvarEstAlcadaCpPed.get("cdCtr"));
                    objSalvarToken.put("cdIt", contador);
                    objSalvarToken.put("cdUsu", usuarioParaLiberacao.get("cdUsu"));
                    objSalvarToken.put("stEnv", usuarioParaLiberacao.get("stUsuLib"));
                    
                    var strToken = objSalvarToken.get("cdCtr") + "-" + objSalvarToken.get("cdGrp") + "-" + objSalvarToken.get("cdUsu") + "-L";
                    var strTokenCancel = objSalvarToken.get("cdCtr") + "-" + objSalvarToken.get("cdGrp") + "-" + objSalvarToken.get("cdUsu") + "-C";

                    strToken = this.mapper.selectList('EstAlcadaCpPedAlcadas.geraMd5', {
                        idToken: strToken
                    });

                    strTokenCancel = this.mapper.selectList('EstAlcadaCpPedAlcadas.geraMd5', {
                        idToken: strTokenCancel
                    });
                    
                    
                    objSalvarToken.put("idToken", strToken.get(0).get("token"));
                    objSalvarToken.put("idTokenCancel", strTokenCancel.get(0).get("token"));
                    
                    this.mapper.insert('EstAlcadaCpPedAlcadas.incluirEstAlcadaCpPedAlcadas', objSalvarToken);
                    
                    if (objSalvarToken.get('stEnv') == 1) {
                        var objSalvarLib = mapperFactory.createMap();
                        objSalvarLib.put("cdIt", contador);
                        objSalvarLib.put("cdUsu", objSalvarToken.get("cdUsu"));
                        objSalvarLib.put("cdCtr", objSalvarToken.get("cdCtr"));
                        this.mapper.insert('EstAlcadaCpPedAlcadasLib.incluirEstAlcadaCpPedAlcadasLib', objSalvarLib);
                    }
                }
            } else {
                throw {
                    code: 599,
                    message: "Gravação de Alçadas, não foi possível gravar os usuários para a liberaçãoa alçadas /n verifique se existe algum Grupo de alçada para demanda e se possui usuários vinculado ao mesmo."
                };
            }
        }

        /* var objSalvarNaAgendaDoUsuario = {
             'cdUsu': obj.get(0).get("agendamento").get(0).get("cdUsu"),
             'title': dsAgd,
             'color': '#483D8B',
             'start': obj.get(0).get("agendamento").get(0).get("validQtdeFaceamento"),
             'end': obj.get(0).get("agendamento").get(0).get("validQtdeFaceamento"),
             'url': 'app.compras.cadastro.alcada',
             'parametros': 'cdEmp: ' + obj.get(0).get("agendamento").get(0).get("cdEmp") + ',tpAlcada: 1 ,estadoAba: liberacao',
             'allDay': '1',
             'eventBloqEdicaoAnteriormente': '0',
             'editable': '0'
         };*/

        // this.agendaDeCompra.vincularAoCalendarioDoUsuario(objSalvarNaAgendaDoUsuario);
        // this.agendaDeCompra.mapper.commit();

        this.mapper.commit();
        
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }

};