function validarCNPJ(cnpj) {
    if(cnpj == '' || cnpj == undefined || cnpj == null) {
        return false;
    }

    if (typeof(cnpj) != 'string') {
        cnpj = cnpj.toString();
    }

    cnpj = cnpj.replace('.','');
    cnpj = cnpj.replace('.','');
    cnpj = cnpj.replace('.','');
    cnpj = cnpj.replace('-','');
    cnpj = cnpj.replace('/','');

    if(cnpj == '') {
        return false;
    }
    if (cnpj.length() != 14){
        return false;
    }
    // Elimina CNPJs invalidos conhecidos
    if (cnpj == '00000000000000' ||
        cnpj == '11111111111111' ||
        cnpj == '22222222222222' ||
        cnpj == '33333333333333' ||
        cnpj == '44444444444444' ||
        cnpj == '55555555555555' ||
        cnpj == '66666666666666' ||
        cnpj == '77777777777777' ||
        cnpj == '88888888888888' ||
        cnpj == '99999999999999')
        return false;

    // Valida DVs
    tamanho = cnpj.length() - 2;
    numeros = String(cnpj.substring(0,tamanho));
    digitos = String(cnpj.substring(tamanho));
    soma = 0;
    pos = 5;
    for (i = 0; i < tamanho; i++) {
        //java.lang.System.out.println('numeros ' + numeros +  ' numeros.charAt(tamanho - i) '+numeros.substring(i,i + 1)+' (tamanho - i) ' + (i) + ' pos '+ (pos));
        soma += numeros.substring(i,i + 1) * (pos);
        pos--;
        if (pos < 2)
            pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - (soma % 11);
    if (resultado != digitos.substring(0,1)){
        return false;
    }
    tamanho = tamanho + 1;
    numeros = cnpj.substring(0,tamanho);
    soma = 0;
    pos = 6;
    for (i = 0; i < tamanho; i++) {
        //java.lang.System.out.println('numeros ' + numeros +  ' numeros.charAt(tamanho - i) '+numeros.substring(i,i + 1)+' (tamanho - i) ' + (i) + ' pos '+ (pos));
        soma += numeros.substring(i,i + 1) * (pos);
        pos--;
        if (pos < 2)
            pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - (soma % 11);
    //java.lang.System.out.println('resultado ' + resultado + ' soma ' + soma + ' digitos.charAt(0) '+ digitos.substring(1,2));
    if (resultado != digitos.substring(1,2))
        return false;

    return true;

}

function validarCPF(cpf) {
  if(cpf == '' || cpf == undefined || cpf == null) return false;
  if (cpf == "00000000000") return false;
  if (cpf == "11111111111") return false;
  if (cpf == "22222222222") return false;
  if (cpf == "33333333333") return false;
  if (cpf == "44444444444") return false;
  if (cpf == "55555555555") return false;
  if (cpf == "66666666666") return false;
  if (cpf == "77777777777") return false;
  if (cpf == "88888888888") return false;
  if (cpf == "99999999999") return false;

   if (typeof(cpf) != 'string') {
        cpf = cpf.toString();
    }

    cpf = cpf.replace('.','');
    cpf = cpf.replace('.','');
    cpf = cpf.replace('.','');
    cpf = cpf.replace('-','');
    cpf = cpf.replace('/','');

  var Soma;
  var Resto;
  Soma = 0;


	for (i=1; i<=9; i++) Soma = Soma + parseInt(cpf.substring(i-1, i)) * (11 - i);
	Resto = (Soma * 10) % 11;

    if ((Resto == 10) || (Resto == 11))  Resto = 0;
    if (Resto != parseInt(cpf.substring(9, 10)) ) return false;

	Soma = 0;
    for (i = 1; i <= 10; i++) Soma = Soma + parseInt(cpf.substring(i-1, i)) * (12 - i);
    Resto = (Soma * 10) % 11;

    if ((Resto == 10) || (Resto == 11))  Resto = 0;
    if (Resto != parseInt(cpf.substring(10, 11) ) ) return false;
    return true;
}
