/**
 * Created by maurodouglas on 01/11/16.
 */
var ValidaProduto = function() {
    this.mapper = mapperFactory.createMapperMult(["EstProd", "EstProdCpl", "EstProdFabric", "EstProdUnMed", "EstProdNcmCadastro", "EstProdMotivoSts"]);
};

ValidaProduto.prototype.validaStatusProdutosByJson = function(json) {

    if (!json) {
        return {
			error : true,
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    var mapper = mapperFactory.createMapperMult(["EstProd", "EstProdCpl", "EstProdFabric", "EstProdUnMed", "EstProdNcmCadastro"]);

	try{
		var produtosEmpresa = mapper.selectList("EstProd.listarEstProdListaDeCdProd", json);
		if (json.cdProd.length != produtosEmpresa.size()) {
			prodNaoEncontrado = [];
			prodEncontrado = 0;
			for (i = 0; i < json.cdProd.length; i++) {
				cdProdEnv = json.cdProd[i];
				prodEncontrado = 0;
				for (j = 0; j < produtosEmpresa.size(); j++) {
					if (cdProdEnv == produtosEmpresa.get(j).get("cdProd")) {
						prodEncontrado = 1;
					}
				}
				if (prodEncontrado == 0) {
					prodNaoEncontrado.push(cdProdEnv);
				}
			}
			if (prodNaoEncontrado.size > 0) {
				return {
					error : true,
					code: 599,
					message: "Produto(s) :  " + prodNaoEncontrado + '  nao cadastrado(s) no sistema'
				};
			}
		} else {
			prodInativo = [];
			prodBloqueado = [];
			for (j = 0; j < produtosEmpresa.size(); j++) {
				if (parseInt(produtosEmpresa.get(j).get("stsProd")) > 0) {
					switch (parseInt(produtosEmpresa.get(j).get("stsProd"))) {
						case 1:
							prodInativo.push(produtosEmpresa.get(j).get("cdProd"));
							break;
						case 2:
							prodBloqueado.push(produtosEmpresa.get(j).get("cdProd"));
							break;
					}
				}
			}
			if (prodInativo.length > 0 || prodBloqueado.length > 0) {
				msg = '';
				if (prodInativo.length > 0) {
					msg += 'Produto(s) :  ' + prodInativo + '  inativo(s) na empresa.';
				}
				if (prodBloqueado.length > 0) {
					msg += ' Produto(s) : ' + prodBloqueado + ' bloqueado(s) na empresa.';
				}
				return {
					error : true,
					code: 599,
					message: msg
				};
			}
		}

		var produtosFiliais = mapper.selectList("EstProdCpl.listarEstProdCplListaDeCdProd", json);

		if (json.cdProd.length != produtosFiliais.size()) {
			prodNaoEncontrado = [];
			prodEncontrado = 0;
			for (i = 0; i < json.cdProd.length; i++) {
				cdProdEnv = json.cdProd[i];
				prodEncontrado = 0;
				for (j = 0; j < produtosFiliais.size(); j++) {
					if (cdProdEnv == produtosFiliais.get(j).get("cdProd")) {
						prodEncontrado = 1;
					}
				}
				if (prodEncontrado == 0) {
					prodNaoEncontrado.push(cdProdEnv);
				}
			}
			if (prodNaoEncontrado.size > 0) {
				return {
					error : true,
					code: 599,
					message: "Produtos :  " + prodNaoEncontrado + '  nao vinculados na filial ' + json.cdFilial
				};
			}
		} else {
			prodInativo = [];
			prodBloqueado = [];
			for (j = 0; j < produtosFiliais.size(); j++) {
				if (parseInt(produtosFiliais.get(j).get("stsProd")) > 0) {
					switch (parseInt(produtosFiliais.get(j).get("stsProd"))) {
						case 1:
							prodInativo.push(produtosFiliais.get(j).get("cdProd"));
							break;
						case 2:
							prodBloqueado.push(produtosFiliais.get(j).get("cdProd"));
							break;
					}
				}
			}
			if (prodInativo.length > 0 || prodBloqueado.length > 0) {
				msg = '';
				if (prodInativo.length > 0) {
					msg += 'Produto(s) :  ' + prodInativo + '  inativo(s) na Filial ' + json.cdFilial;
				}
				if (prodBloqueado.length > 0) {
					msg += ' Produto(s) : ' + prodBloqueado + ' bloqueado(s) na Filial ' + json.cdFilial;
				}
				return {
					error : true,
					code: 599,
					message: msg
				};
			}
		}

		
	}finally{
		mapper.close();
	}
	
};

ValidaProduto.prototype.validaStatusProdutos = function(json) {

    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    var produtosEmpresa = this.mapper.selectList("EstProd.listarEstProdListaDeCdProd", json);
    if (json.cdProd.length != produtosEmpresa.size()) {
        prodNaoEncontrado = [];
        prodEncontrado = 0;
        for (i = 0; i < json.cdProd.length; i++) {
            cdProdEnv = json.cdProd[i];
            prodEncontrado = 0;
            for (j = 0; j < produtosEmpresa.size(); j++) {
                if (cdProdEnv == produtosEmpresa.get(j).get("cdProd")) {
                    prodEncontrado = 1;
                }
            }
            if (prodEncontrado == 0) {
                prodNaoEncontrado.push(cdProdEnv);
            }
        }
        if (prodNaoEncontrado.size > 0) {
            throw {
                code: 599,
                message: "Produto(s) :  " + prodNaoEncontrado + '  nao cadastrado(s) no sistema'
            };
        }
    } else {
        prodInativo = [];
        prodBloqueado = [];
        for (j = 0; j < produtosEmpresa.size(); j++) {
            if (parseInt(produtosEmpresa.get(j).get("stsProd")) > 0) {
                switch (parseInt(produtosEmpresa.get(j).get("stsProd"))) {
                    case 1:
                        prodInativo.push(produtosEmpresa.get(j).get("cdProd"));
                        break;
                    case 2:
                        prodBloqueado.push(produtosEmpresa.get(j).get("cdProd"));
                        break;
                }
            }
        }
        if (prodInativo.length > 0 || prodBloqueado.length > 0) {
            msg = '';
            if (prodInativo.length > 0) {
                msg += 'Produto(s) :  ' + prodInativo + '  inativo(s) na empresa.';
            }
            if (prodBloqueado.length > 0) {
                msg += ' Produto(s) : ' + prodBloqueado + ' bloqueado(s) na empresa.';
            }
            throw {
                code: 599,
                message: msg
            };
        }
    }

    var produtosFiliais = this.mapper.selectList("EstProdCpl.listarEstProdCplListaDeCdProd", json);

    if (json.cdProd.length != produtosFiliais.size()) {
        prodNaoEncontrado = [];
        prodEncontrado = 0;
        for (i = 0; i < json.cdProd.length; i++) {
            cdProdEnv = json.cdProd[i];
            prodEncontrado = 0;
            for (j = 0; j < produtosFiliais.size(); j++) {
                if (cdProdEnv == produtosFiliais.get(j).get("cdProd")) {
                    prodEncontrado = 1;
                }
            }
            if (prodEncontrado == 0) {
                prodNaoEncontrado.push(cdProdEnv);
            }
        }
        if (prodNaoEncontrado.size > 0) {
            throw {
                code: 599,
                message: "Produtos :  " + prodNaoEncontrado + '  nao vinculados na filial ' + json.cdFilial
            };
        }
    } else {
        prodInativo = [];
        prodBloqueado = [];
        for (j = 0; j < produtosFiliais.size(); j++) {
            if (parseInt(produtosFiliais.get(j).get("stsProd")) > 0) {
                switch (parseInt(produtosFiliais.get(j).get("stsProd"))) {
                    case 1:
                        prodInativo.push(produtosFiliais.get(j).get("cdProd"));
                        break;
                    case 2:
                        prodBloqueado.push(produtosFiliais.get(j).get("cdProd"));
                        break;
                }
            }
        }
        if (prodInativo.length > 0 || prodBloqueado.length > 0) {
            msg = '';
            if (prodInativo.length > 0) {
                msg += 'Produto(s) :  ' + prodInativo + '  inativo(s) na Filial ' + json.cdFilial;
            }
            if (prodBloqueado.length > 0) {
                msg += ' Produto(s) : ' + prodBloqueado + ' bloqueado(s) na Filial ' + json.cdFilial;
            }
            throw {
                code: 599,
                message: msg
            };
        }
    }
};

ValidaProduto.prototype.validaStatusProdutosVenda = function(json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    var produtosEmpresa = this.mapper.selectList("EstProd.listarEstProdListaDeCdProd", json);
    if (json.cdProd.length != produtosEmpresa.size()) {
        prodNaoEncontrado = [];
        prodEncontrado = 0;
        for (i = 0; i < json.cdProd.length; i++) {
            cdProdEnv = json.cdProd[i];
            prodEncontrado = 0;
            for (j = 0; j < produtosEmpresa.size(); j++) {
                if (cdProdEnv == produtosEmpresa.get(j).get("cdProd")) {
                    prodEncontrado = 1;
                }
            }
            if (prodEncontrado == 0) {
                prodNaoEncontrado.push(cdProdEnv);
            }
        }
        if (prodNaoEncontrado.length > 0) {
            throw {
                code: 599,
                message: "Produto(s) :  " + prodNaoEncontrado + '  nao cadastrado(s) no sistema'
            };
        }
    } else {
        prodInativo = [];
        for (j = 0; j < produtosEmpresa.size(); j++) {
            if (parseInt(produtosEmpresa.get(j).get("stsProd")) == 1) {
                prodInativo.push(produtosEmpresa.get(j).get("cdProd"));
            }
        }
        if (prodInativo.length > 0) {
            throw {
                code: 599,
                message: "Produto(s) :  " + prodInativo + '  inativo(s) na empresa.'
            };
        }
    }

    var jsonConvert = new com.google.gson.GsonBuilder().create();
    var produtosFiliais = this.mapper.selectList("EstProdCpl.listarEstProdCplListaDeCdProd", json);


    if (json.cdProd.length != produtosFiliais.size()) {
        prodNaoEncontrado = [];
        prodEncontrado = 0;
        for (i = 0; i < json.cdProd.length; i++) {
            cdProdEnv = json.cdProd[i];
            prodEncontrado = 0;
            for (j = 0; j < produtosFiliais.size(); j++) {
                if (cdProdEnv == produtosFiliais.get(j).get("cdProd")) {
                    prodEncontrado = 1;
                }
            }
            if (prodEncontrado == 0) {
                prodNaoEncontrado.push(cdProdEnv);
            }

        }
        if (prodNaoEncontrado.length > 0) {
            throw {
                code: 599,
                message: "Produtos :  " + prodNaoEncontrado + '  nao vinculados na filial ' + json.cdFilial
            };
        }
    } else {
        prodInativo = [];
        for (j = 0; j < produtosFiliais.size(); j++) {
            if (parseInt(produtosFiliais.get(j).get("stsProd")) == 1) {
                prodInativo.push(produtosFiliais.get(j).get("cdProd"));
            }
        }
        if (prodInativo.length > 0) {
            throw {
                code: 599,
                message: "Produto(s) :  " + prodInativo + '  inativo(s) na Filial ' + json.cdFilial + '.'
            };
        }
    }
};

ValidaProduto.prototype.validarStatusDoProdutoNoCadastro = function(json, filial){
	if((json.get("stsProd") == 1 || json.get("stsProd") == 2) && (json.get("cdMotivoSts") == null || json.get("cdMotivoSts") == 0))
		throw {'code': 599, 'message': "Para status de produto inativo ou bloqueado deve ser informado o motivo"};
		
	if(json.get("stsProd") != 0 && json.get("cdProd")){
		let estoque = this.mapper.selectOne("EstProdCpl.getEstoqueDoProduto", {'cdEmp':json.get('cdEmp'), 'cdProd':json.get('cdProd') , 'cdFilial':filial});
		if(json.get("stsProd") == 1 && estoque.get('qtEst') > 0)
			throw {'code': 599, 'message': "Produto com estoque diferente de zero em alguma filial, não poderá ser inativado"};
		if(estoque.get('qtPendEnt') > 0)
        	throw {'code': 599, 'message': "Produto com pendência de entrada, não poderá ser inativado e nem bloqueado"};
	}
		
	if(json.get("stsProd") == 1 || json.get("stsProd") == 2 || (json.get("stsProd") == 0 && (json.get("cdMotivoSts") != null && json.get("cdMotivoSts") > 0))){
		let motivos = this.mapper.selectList("EstProdMotivoSts.listarEstProdMotivoSts", {});
		for(let i = 0; i<motivos.size(); i++){
			if(motivos.get(i).get('cdMotivoSts') == json.get("cdMotivoSts") && motivos.get(i).get('stsProd') != json.get("stsProd"))
				throw {'code': 599, 'message': "Motivo não esta vinculado ao status do produto"};
		}
	}

};

ValidaProduto.prototype.validaDadosCadastroProduto = function(json) {
    if (!json)
       throw {'code': 599, 'message': "Dados passados ao servidor inválido!"};
    
    if (!json.get("dsProd") || json.get("dsProd") === null || json.get("dsProd") === undefined)
        throw {'code': 599, 'message': 'Descricao do produto nao informado'};
    
    if (!json.get("dsUsual") || json.get("dsUsual") === null || json.get("dsUsual") === undefined) 
        throw {'code': 599, 'message': 'Descricao usual  do produto nao informado'};
    
    if (!json.get("cdFabric") || json.get("cdFabric") === null || json.get("cdFabric") === undefined) {
        throw {'code': 599, 'message': 'Fabricante do produto nao informado'};
    } else {
        variaveis = {'cdFabric': json.get("cdFabric")};
        fabricante = this.mapper.selectOne("EstProdFabric.listarEstProdFabric", variaveis);
        if (!fabricante) 
            throw {'code': 599, 'message': "Fabricante " + variaveis.cdFabric + " nao cadastrado no sistema. "};
    }

    if (!json.get("cdUnVd") || json.get("cdUnVd") === null || json.get("cdUnVd") === undefined) {
        throw {'code': 599, 'message': 'Unidade de venda do produto nao informado'}; 
    } else {
        variaveis = {'cdCtrUn': json.get("cdUnVd")};
        unidadeDeMedida = this.mapper.selectOne("EstProdUnMed.listarEstProdUnMed", variaveis);
        if (!unidadeDeMedida) 
            throw {'code': 599, 'message': "Unidade de venda " + variaveis.cdCtrUn + " nao cadastrado no sistema. "}; 
    }
    
    if (!json.get("apresEmbVd") || json.get("apresEmbVd") === null || json.get("apresEmbVd") === undefined)
        throw {'code': 599, 'message': 'Embalagem de venda do produto nao informado'};
    
    if (!json.get("apresQtVd") || json.get("apresQtVd") === null || json.get("apresQtVd") === undefined)
        json.put("apresQtVd", 1);
    
    if (!json.get("cdUnCp") || json.get("cdUnCp") === null || json.get("cdUnCp") === undefined) {
        throw {'code': 599, 'message': 'Unidade de compra do produto nao informado'};
    } else {
        variaveis = {'cdCtrUn': json.get("cdUnCp")};
        unidadeDeMedida = this.mapper.selectOne("EstProdUnMed.listarEstProdUnMed", variaveis);
        if (!unidadeDeMedida) 
            throw {'code': 599, 'message': "Unidade de compra " + variaveis.cdCtrUn + " nao cadastrado no sistema. "};
    }
    
    if (!json.get("apresEmbCpOld") || json.get("apresEmbCpOld") === null || json.get("apresEmbCpOld") === undefined)
        throw {'code': 599, 'message': 'Embalagem de compra do produto nao informado'};
    
    
    if (!json.get("apresQtCp") || json.get("apresQtCp") === null || json.get("apresQtCp") === undefined)
        json.put("apresQtCp", 1);
    
    if (!json.get("nrNcm") || json.get("nrNcm") === null || json.get("nrNcm") === undefined) {
        throw {'code': 599, 'message': 'Numero de NCM do produto nao informado'};
    } else {
        variaveis = {'nrNcm': json.get("nrNcm")};
        numeroNcm = this.mapper.selectOne("EstProdNcmCadastro.listarEstProdNcmCadastro", variaveis);
        if (!numeroNcm)
            throw {'code': 599, 'message': "NCM " + variaveis.nrNcm + " nao cadastrado no sistema. "};
    }
    
    this.validarStatusDoProdutoNoCadastro(json);
    
};

ValidaProduto.prototype.dadosDefault = function(json) {
    if (!json.get("antibiotico") || json.get("antibiotico") === null || json.get("antibiotico") === undefined) {
        json.put("antibiotico", 0);
    }
    if (!json.get("apresEmbCp") || json.get("apresEmbCp") === null || json.get("apresEmbCp") === undefined) {
        json.put("apresEmbCp", 1);
    }
    if (!json.get("apresEmbCpOld") || json.get("apresEmbCpOld") === null || json.get("apresEmbCpOld") === undefined) {
        json.put("apresEmbCpOld", " ");
    }
    if (!json.get("apresEmbVd") || json.get("apresEmbVd") === null || json.get("apresEmbVd") === undefined) {
        json.put("apresEmbVd", " ");
    }
    if (!json.get("apresQtCp") || json.get("apresQtCp") === null || json.get("apresQtCp") === undefined) {
        json.put("apresQtCp", 1);
    }
    if (!json.get("apresQtVd") || json.get("apresQtVd") === null || json.get("apresQtVd") === undefined) {
        json.put("apresQtVd", 1);
    }
    if (!json.get("cdAplic") || json.get("cdAplic") === null || json.get("cdAplic") === undefined) {
        json.put("cdAplic", 0);
    }
    if (!json.get("cdClassFisc") || json.get("cdClassFisc") === null || json.get("cdClassFisc") === undefined) {
        json.put("cdClassFisc", 0);
    }
    if (!json.get("cdCorReceita") || json.get("cdCorReceita") === null || json.get("cdCorReceita") === undefined) {
        json.put("cdCorReceita", 0);
    }
    if (!json.get("cdCstCofinsEntrada") || json.get("cdCstCofinsEntrada") === null || json.get("cdCstCofinsEntrada") === undefined) {
        json.put("cdCstCofinsEntrada", 0);
    }
    if (!json.get("cdCstCofinsSaida") || json.get("cdCstCofinsSaida") === null || json.get("cdCstCofinsSaida") === undefined) {
        json.put("cdCstCofinsSaida", 0);
    }
    if (!json.get("cdCstPisEntrada") || json.get("cdCstPisEntrada") === null || json.get("cdCstPisEntrada") === undefined) {
        json.put("cdCstPisEntrada", 0);
    }
    if (!json.get("cdCstPisSaida") || json.get("cdCstPisSaida") === null || json.get("cdCstPisSaida") === undefined) {
        json.put("cdCstPisSaida", 0);
    }
    if (!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined) {
        json.put("cdEmp", 1);
    }
    if (!json.get("cdFabric") || json.get("cdFabric") === null || json.get("cdFabric") === undefined) {
        json.put("cdFabric", 0);
    }
    if (!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined) {
        json.put("cdFilial", 0);
    }
    if (!json.get("cdGrp") || json.get("cdGrp") === null || json.get("cdGrp") === undefined) {
        json.put("cdGrp", 0);
    }
    if (!json.get("cdGrpSub") || json.get("cdGrpSub") === null || json.get("cdGrpSub") === undefined) {
        json.put("cdGrpSub", 0);
    }
    if (!json.get("cdMc") || json.get("cdMc") === null || json.get("cdMc") === undefined) {
        json.put("cdMc", 0);
    }
    if (!json.get("cdSc") || json.get("cdSc") === null || json.get("cdSc") === undefined) {
        json.put("cdSc", 0);
    }
    if (!json.get("cdTpReceita") || json.get("cdTpReceita") === null || json.get("cdTpReceita") === undefined) {
        json.put("cdTpReceita", 0);
    }
    if (!json.get("cdUnCp") || json.get("cdUnCp") === null || json.get("cdUnCp") === undefined) {
        json.put("cdUnCp", 0);
    }
    if (!json.get("cdUnVd") || json.get("cdUnVd") === null || json.get("cdUnVd") === undefined) {
        json.put("cdUnVd", 0);
    }
    if (!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined) {
        json.put("cdUsu", 1);
    }
    if (!json.get("compraPorSuprimento") || json.get("compraPorSuprimento") === null || json.get("compraPorSuprimento") === undefined) {
        json.put("compraPorSuprimento", 0);
    }
    if (!json.get("controleSngpc") || json.get("controleSngpc") === null || json.get("controleSngpc") === undefined) {
        json.put("controleSngpc", 0);
    }
    if (!json.get("ctrLote") || json.get("ctrLote") === null || json.get("ctrLote") === undefined) {
        json.put("ctrLote", 0);
    }
    if (!json.get("ctrPmc") || json.get("ctrPmc") === null || json.get("ctrPmc") === undefined) {
        json.put("ctrPmc", 0);
    }
    if (!json.get("diaVld") || json.get("diaVld") === null || json.get("diaVld") === undefined) {
        json.put("diaVld", 0);
    }
    if (!json.get("dsProd") || json.get("dsProd") === null || json.get("dsProd") === undefined) {
        json.put("dsProd", " ");
    }
    if (!json.get("dsUsual") || json.get("dsUsual") === null || json.get("dsUsual") === undefined) {
        json.put("dsUsual", " ");
    }
    if (!json.get("flagAlterarPreco") || json.get("flagAlterarPreco") === null || json.get("flagAlterarPreco") === undefined) {
        json.put("flagAlterarPreco", 0);
    }
    if (!json.get("flagAnaliseFaltas") || json.get("flagAnaliseFaltas") === null || json.get("flagAnaliseFaltas") === undefined) {
        json.put("flagAnaliseFaltas", 0);
    }
    if (!json.get("flagDescontoTicketBlq") || json.get("flagDescontoTicketBlq") === null || json.get("flagDescontoTicketBlq") === undefined) {
        json.put("flagDescontoTicketBlq", 0);
    }
    if (!json.get("flagDiretoPdv") || json.get("flagDiretoPdv") === null || json.get("flagDiretoPdv") === undefined) {
        json.put("flagDiretoPdv", 0);
    }
    if (!json.get("flagExcecaoPisCofins") || json.get("flagExcecaoPisCofins") === null || json.get("flagExcecaoPisCofins") === undefined) {
        json.put("flagExcecaoPisCofins", 0);
    }
    if (!json.get("flagIgnorarPmcSubst") || json.get("flagIgnorarPmcSubst") === null || json.get("flagIgnorarPmcSubst") === undefined) {
        json.put("flagIgnorarPmcSubst", 0);
    }
    if (!json.get("flagNaoAparecerEstatisticaCompraCliente") || json.get("flagNaoAparecerEstatisticaCompraCliente") === null || json.get("flagNaoAparecerEstatisticaCompraCliente") === undefined) {
        json.put("flagNaoAparecerEstatisticaCompraCliente", 0);
    }
    if (!json.get("flagNaoFacearAutomatico") || json.get("flagNaoFacearAutomatico") === null || json.get("flagNaoFacearAutomatico") === undefined) {
        json.put("flagNaoFacearAutomatico", 0);
    }
    if (!json.get("flagNaoPermitirDevolucao") || json.get("flagNaoPermitirDevolucao") === null || json.get("flagNaoPermitirDevolucao") === undefined) {
        json.put("flagNaoPermitirDevolucao", 0);
    }
    if (!json.get("flagPermiteRessarcimentoIcms") || json.get("flagPermiteRessarcimentoIcms") === null || json.get("flagPermiteRessarcimentoIcms") === undefined) {
        json.put("flagPermiteRessarcimentoIcms", 0);
    }
    if (!json.get("flagProdCestaBasica") || json.get("flagProdCestaBasica") === null || json.get("flagProdCestaBasica") === undefined) {
        json.put("flagProdCestaBasica", 0);
    }
    if (!json.get("flagProdKit") || json.get("flagProdKit") === null || json.get("flagProdKit") === undefined) {
        json.put("flagProdKit", 0);
    }
    if (!json.get("flagProdutoBlister") || json.get("flagProdutoBlister") === null || json.get("flagProdutoBlister") === undefined) {
        json.put("flagProdutoBlister", 0);
    }
    if (!json.get("flagProdutoControlado") || json.get("flagProdutoControlado") === null || json.get("flagProdutoControlado") === undefined) {
        json.put("flagProdutoControlado", 0);
    }
    if (!json.get("flagProdutoCotacao") || json.get("flagProdutoCotacao") === null || json.get("flagProdutoCotacao") === undefined) {
        json.put("flagProdutoCotacao", 0);
    }
    if (!json.get("flagProdutoEtico") || json.get("flagProdutoEtico") === null || json.get("flagProdutoEtico") === undefined) {
        json.put("flagProdutoEtico", 0);
    }
    if (!json.get("flagProdutoGenerico") || json.get("flagProdutoGenerico") === null || json.get("flagProdutoGenerico") === undefined) {
        json.put("flagProdutoGenerico", 0);
    }
    if (!json.get("flagProdutoSimilar") || json.get("flagProdutoSimilar") === null || json.get("flagProdutoSimilar") === undefined) {
        json.put("flagProdutoSimilar", 0);
    }
    if (!json.get("flagProdutoTaxaEntrega") || json.get("flagProdutoTaxaEntrega") === null || json.get("flagProdutoTaxaEntrega") === undefined) {
        json.put("flagProdutoTaxaEntrega", 0);
    }
    if (!json.get("flagPromoForn") || json.get("flagPromoForn") === null || json.get("flagPromoForn") === undefined) {
        json.put("flagPromoForn", 0);
    }
    if (!json.get("flagRequerReceit") || json.get("flagRequerReceit") === null || json.get("flagRequerReceit") === undefined) {
        json.put("flagRequerReceit", 0);
    }
    if (!json.get("flagRessarcimento") || json.get("flagRessarcimento") === null || json.get("flagRessarcimento") === undefined) {
        json.put("flagRessarcimento", 0);
    }
    if (!json.get("flagRessuprimentoCaixaFechada") || json.get("flagRessuprimentoCaixaFechada") === null || json.get("flagRessuprimentoCaixaFechada") === undefined) {
        json.put("flagRessuprimentoCaixaFechada", 0);
    }
    if (!json.get("flagTribPisCofinsProd") || json.get("flagTribPisCofinsProd") === null || json.get("flagTribPisCofinsProd") === undefined) {
        json.put("flagTribPisCofinsProd", 0);
    }
    if (!json.get("flagTrocaFornecedor") || json.get("flagTrocaFornecedor") === null || json.get("flagTrocaFornecedor") === undefined) {
        json.put("flagTrocaFornecedor", 0);
    }
    if (!json.get("flagVdCallCenter") || json.get("flagVdCallCenter") === null || json.get("flagVdCallCenter") === undefined) {
        json.put("flagVdCallCenter", 0);
    }
    if (!json.get("flagVendaConsignada") || json.get("flagVendaConsignada") === null || json.get("flagVendaConsignada") === undefined) {
        json.put("flagVendaConsignada", 0);
    }
    if (!json.get("flagVendaPeriodica") || json.get("flagVendaPeriodica") === null || json.get("flagVendaPeriodica") === undefined) {
        json.put("flagVendaPeriodica", 0);
    }
    if (!json.get("flagVerbaDescon") || json.get("flagVerbaDescon") === null || json.get("flagVerbaDescon") === undefined) {
        json.put("flagVerbaDescon", 0);
    }
    if (!json.get("fracaoAbcFarma") || json.get("fracaoAbcFarma") === null || json.get("fracaoAbcFarma") === undefined) {
        json.put("fracaoAbcFarma", 1);
    }
    if (!json.get("geraBlnc") || json.get("geraBlnc") === null || json.get("geraBlnc") === undefined) {
        json.put("geraBlnc", 0);
    }
    if (!json.get("geraEtqRes") || json.get("geraEtqRes") === null || json.get("geraEtqRes") === undefined) {
        json.put("geraEtqRes", 0);
    }
    if (!json.get("listaProd") || json.get("listaProd") === null || json.get("listaProd") === undefined) {
        json.put("listaProd", 0);
    }
    if (!json.get("nrCest") || json.get("nrCest") === null || json.get("nrCest") === undefined) {
        json.put("nrCest", " ");
    }
    if (!json.get("nrItemRea") || json.get("nrItemRea") === null || json.get("nrItemRea") === undefined) {
        json.put("nrItemRea", 0);
    }
    if (!json.get("nrNcm") || json.get("nrNcm") === null || json.get("nrNcm") === undefined) {
        json.put("nrNcm", 0);
    }
    if (!json.get("nrServ") || json.get("nrServ") === null || json.get("nrServ") === undefined) {
        json.put("nrServ", " ");
    }
    if (!json.get("obsProd") || json.get("obsProd") === null || json.get("obsProd") === undefined) {
        json.put("obsProd", " ");
    }
    if (!json.get("origemProduto") || json.get("origemProduto") === null || json.get("origemProduto") === undefined) {
        json.put("origemProduto", 0);
    }
    if (!json.get("percAliqReaEstadual") || json.get("percAliqReaEstadual") === null || json.get("percAliqReaEstadual") === undefined) {
        json.put("percAliqReaEstadual", 0);
    }
    if (!json.get("percAliqReaInterestadual") || json.get("percAliqReaInterestadual") === null || json.get("percAliqReaInterestadual") === undefined) {
        json.put("percAliqReaInterestadual", 0);
    }
    if (!json.get("percComis") || json.get("percComis") === null || json.get("percComis") === undefined) {
        json.put("percComis", 0);
    }
    if (!json.get("percComisDescExt") || json.get("percComisDescExt") === null || json.get("percComisDescExt") === undefined) {
        json.put("percComisDescExt", 0);
    }
    if (!json.get("percComisDescInt") || json.get("percComisDescInt") === null || json.get("percComisDescInt") === undefined) {
        json.put("percComisDescInt", 0);
    }
    if (!json.get("percComisInterno") || json.get("percComisInterno") === null || json.get("percComisInterno") === undefined) {
        json.put("percComisInterno", 0);
    }
    if (!json.get("percComisServico") || json.get("percComisServico") === null || json.get("percComisServico") === undefined) {
        json.put("percComisServico", 0);
    }
    if (!json.get("percDesc") || json.get("percDesc") === null || json.get("percDesc") === undefined) {
        json.put("percDesc", 0);
    }
    if (!json.get("percDescFabrica") || json.get("percDescFabrica") === null || json.get("percDescFabrica") === undefined) {
        json.put("percDescFabrica", 0);
    }
    if (!json.get("percDescFidel") || json.get("percDescFidel") === null || json.get("percDescFidel") === undefined) {
        json.put("percDescFidel", 0);
    }
    if (!json.get("percDescFidelMax") || json.get("percDescFidelMax") === null || json.get("percDescFidelMax") === undefined) {
        json.put("percDescFidelMax", 0);
    }
    if (!json.get("percDescFinan") || json.get("percDescFinan") === null || json.get("percDescFinan") === undefined) {
        json.put("percDescFinan", 0);
    }
    if (!json.get("percDescFix") || json.get("percDescFix") === null || json.get("percDescFix") === undefined) {
        json.put("percDescFix", 0);
    }
    if (!json.get("percDescLimite") || json.get("percDescLimite") === null || json.get("percDescLimite") === undefined) {
        json.put("percDescLimite", 0);
    }
    if (!json.get("percMargem") || json.get("percMargem") === null || json.get("percMargem") === undefined) {
        json.put("percMargem", 0);
    }
    if (!json.get("pesoProdCp") || json.get("pesoProdCp") === null || json.get("pesoProdCp") === undefined) {
        json.put("pesoProdCp", 0);
    }
    if (!json.get("pesoProdVd") || json.get("pesoProdVd") === null || json.get("pesoProdVd") === undefined) {
        json.put("pesoProdVd", 0);
    }
    if (!json.get("pisCofins") || json.get("pisCofins") === null || json.get("pisCofins") === undefined) {
        json.put("pisCofins", 0);
    }
    if (!json.get("pluProd") || json.get("pluProd") === null || json.get("pluProd") === undefined) {
        json.put("pluProd", " ");
    }
    if (!json.get("prodLiberado") || json.get("prodLiberado") === null || json.get("prodLiberado") === undefined) {
        json.put("prodLiberado", 0);
    }
    if (!json.get("prodUsoCont") || json.get("prodUsoCont") === null || json.get("prodUsoCont") === undefined) {
        json.put("prodUsoCont", 0);
    }
    if (!json.get("promoIndustria") || json.get("promoIndustria") === null || json.get("promoIndustria") === undefined) {
        json.put("promoIndustria", 0);
    }
    if (!json.get("qtUniRessuprimento") || json.get("qtUniRessuprimento") === null || json.get("qtUniRessuprimento") === undefined) {
        json.put("qtUniRessuprimento", 0);
    }
    if (!json.get("qtdeCaixa") || json.get("qtdeCaixa") === null || json.get("qtdeCaixa") === undefined) {
        json.put("qtdeCaixa", 0);
    }
    if (!json.get("qtdeDiasTratamentoProd") || json.get("qtdeDiasTratamentoProd") === null || json.get("qtdeDiasTratamentoProd") === undefined) {
        json.put("qtdeDiasTratamentoProd", 0);
    }
    if (!json.get("qtdeLitro") || json.get("qtdeLitro") === null || json.get("qtdeLitro") === undefined) {
        json.put("qtdeLitro", 0);
    }
    if (!json.get("siglaExcecaoPisCofins") || json.get("siglaExcecaoPisCofins") === null || json.get("siglaExcecaoPisCofins") === undefined) {
        json.put("siglaExcecaoPisCofins", " ");
    }
    if (!json.get("stsProd") || json.get("stsProd") === null || json.get("stsProd") === undefined) {
        json.put("stsProd", 0);
    }
    if (!json.get("cdMotivoSts") || json.get("cdMotivoSts") === null || json.get("cdMotivoSts") === undefined) {
      json.put("cdMotivoSts", 0);
    }
    if (!json.get("stsProdCallCenter") || json.get("stsProdCallCenter") === null || json.get("stsProdCallCenter") === undefined) {
        json.put("stsProdCallCenter", 0);
    }
    if (!json.get("tipoTributacaoPisCofins") || json.get("tipoTributacaoPisCofins") === null || json.get("tipoTributacaoPisCofins") === undefined) {
        json.put("tipoTributacaoPisCofins", 0);
    }
    if (!json.get("tipoTributacaoPisCofinsEntrada") || json.get("tipoTributacaoPisCofinsEntrada") === null || json.get("tipoTributacaoPisCofinsEntrada") === undefined) {
        json.put("tipoTributacaoPisCofinsEntrada", 0);
    }
    if (!json.get("tpExpl") || json.get("tpExpl") === null || json.get("tpExpl") === undefined) {
        json.put("tpExpl", 0);
    }
    if (!json.get("tpServProd") || json.get("tpServProd") === null || json.get("tpServProd") === undefined) {
        json.put("tpServProd", 0);
    }
    if (!json.get("umm") || json.get("umm") === null || json.get("umm") === undefined) {
        json.put("umm", 1);
    }
    if (!json.get("vlrComissaoFabric") || json.get("vlrComissaoFabric") === null || json.get("vlrComissaoFabric") === undefined) {
        json.put("vlrComissaoFabric", 0);
    }
    if (!json.get("vlrCompraGrp") || json.get("vlrCompraGrp") === null || json.get("vlrCompraGrp") === undefined) {
        json.put("vlrCompraGrp", 0);
    }
    if (!json.get("vlrCustoGrp") || json.get("vlrCustoGrp") === null || json.get("vlrCustoGrp") === undefined) {
        json.put("vlrCustoGrp", 0);
    }
    if (!json.get("vlrFabrica") || json.get("vlrFabrica") === null || json.get("vlrFabrica") === undefined) {
        json.put("vlrFabrica", 0);
    }
    if (!json.get("vlrPrecoFranquia") || json.get("vlrPrecoFranquia") === null || json.get("vlrPrecoFranquia") === undefined) {
        json.put("vlrPrecoFranquia", 0);
    }
    if (!json.get("vlrPrecoOperadorLog") || json.get("vlrPrecoOperadorLog") === null || json.get("vlrPrecoOperadorLog") === undefined) {
        json.put("vlrPrecoOperadorLog", 0);
    }
    if (!json.get("vlrProd") || json.get("vlrProd") === null || json.get("vlrProd") === undefined) {
        json.put("vlrProd", 0);
    }

    return json;
};


/**
 * Metodo valida os dados enviados para o cadasto do Produto
 * @param {HashMap JAVA} json
 * @throws {InvalidArgumentException}
 */
ValidaProduto.prototype.validaDadosParaCadastro = function(json) {
    if(!json) 
      throw {'code': 599, 'message': "Dados passados ao servidor inválido!"};
    

    if (!json.get("importador") || json.get("importador") === null || json.get("importador") === undefined || json.get("importador") == 0)
      this.validaDadosCadastroProduto(json);

    var dadosDefault = this.dadosDefault(json);
    return dadosDefault;
};

/**
 * Metodo valida os dados enviados para o cadasto do Fechamento de Estoque
 * @param {HashMap JAVA} json
 * @throws {InvalidArgumentException}
 */
ValidaProduto.prototype.validaDadosParaCadastroFechamentoEstoque = function(json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    var dadosDefault = this.dadosDefaultFechamentoEstoque(json);
    return dadosDefault;
};


ValidaProduto.prototype.dadosDefaultFechamentoEstoque = function(json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    var hoje = new Date();
    var data = new Date();
    data.setDate(hoje.getDate() - 1);
    var mm = data.getMonth() + 1; //January is 0!
    var yyyy = data.getFullYear() - 1;


    if (!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined) {
        json.put("cdEmp", 1);
    }
    if (!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined) {
        json.put("cdFilial", 0);
    }
    if (!json.get("anoFecha") || json.get("anoFecha") === null || json.get("anoFecha") === undefined) {
        json.put("anoFecha", yyyy);
    }
    if (!json.get("mesFecha") || json.get("mesFecha") === null || json.get("mesFecha") === undefined) {
        json.put("mesFecha", mm);
    }
    if (!json.get("cdProd") || json.get("cdProd") === null || json.get("cdProd") === undefined) {
        json.put("cdProd", 0);
    }
    if (!json.get("qtEst") || json.get("qtEst") === null || json.get("qtEst") === undefined) {
        json.put("qtEst", 0);
    }
    if (!json.get("qtEnt") || json.get("qtEnt") === null || json.get("qtEnt") === undefined) {
        json.put("qtEnt", 0);
    }
    if (!json.get("qtSai") || json.get("qtSai") === null || json.get("qtSai") === undefined) {
        json.put("qtSai", 0);
    }
    if (!json.get("qtMe") || json.get("qtMe") === null || json.get("qtMe") === undefined) {
        json.put("qtMe", 0);
    }
    if (!json.get("qtImp") || json.get("qtImp") === null || json.get("qtImp") === undefined) {
        json.put("qtImp", 0);
    }
    if (!json.get("qtTransfSai") || json.get("qtTransfSai") === null || json.get("qtTransfSai") === undefined) {
        json.put("qtTransfSai", 0);
    }
    if (!json.get("qtTransfEnt") || json.get("qtTransfEnt") === null || json.get("qtTransfEnt") === undefined) {
        json.put("qtTransfEnt", 0);
    }
    if (!json.get("vlrCusto") || json.get("vlrCusto") === null || json.get("vlrCusto") === undefined) {
        json.put("vlrCusto", 0);
    }
    if (!json.get("vlrCustoIni") || json.get("vlrCustoIni") == null || json.get("vlrCustoIni") == undefined) {
        itemValidado.put("vlrCustoIni", json.get("vlrCusto"));
    }
    if (!json.get("vlrCustoGer") || json.get("vlrCustoGer") == null || json.get("vlrCustoGer") == undefined) {
        itemValidado.put("vlrCustoGer", json.get("vlrCusto"));
    }
    if (!json.get("vlrVd") || json.get("vlrVd") == null || json.get("vlrVd") == undefined) {
        itemValidado.put("vlrVd", json.get("vlrCusto"));
    }
    if (!json.get("vlrCustoMd") || json.get("vlrCustoMd") == null || json.get("vlrCustoMd") == undefined) {
        itemValidado.put("vlrCustoMd", json.get("vlrCusto"));
    }
    if (!json.get("vlrSubsProd") || json.get("vlrSubsProd") === null || json.get("vlrSubsProd") === undefined) {
        json.put("vlrSubsProd", 0);
    }
    if (!json.get("vlrIcmsProd") || json.get("vlrIcmsProd") === null || json.get("vlrIcmsProd") === undefined) {
        json.put("vlrIcmsProd", 0);
    }
    if (!json.get("cdSigla") || json.get("cdSigla") === null || json.get("cdSigla") === undefined) {
        json.put("cdSigla", 0);
    }
    if (!json.get("qtEstFlut") || json.get("qtEstFlut") === null || json.get("qtEstFlut") === undefined) {
        json.put("qtEstFlut", 0);
    }
    if (!json.get("qtEstEmTerc") || json.get("qtEstEmTerc") === null || json.get("qtEstEmTerc") === undefined) {
        json.put("qtEstEmTerc", 0);
    }
    if (!json.get("qtEstDeTerc") || json.get("qtEstDeTerc") === null || json.get("qtEstDeTerc") === undefined) {
        json.put("qtEstDeTerc", 0);
    }
    if (!json.get("mediaf") || json.get("mediaf") === null || json.get("mediaf") === undefined) {
        json.put("mediaf", 0);
    }

    return json;
};
