/**
 * Created by maurodouglas on 01/11/16.
 */

load('/basicos/validaCpfCnpj.js');
 var ValidaFornecedor = function() {
    this.mapper = mapperFactory.createMapperMult(["PgForn","PgFornRcCli"]);
 };

 ValidaFornecedor.prototype.validaDadosBasicos = function(json){
  if(!json){
    throw {code: 599, message: "Dados passados ao servidor inválido!"};
  }
  if(json.get("cgcCpf") && json.get("cgcCpf").length() >= 13){
   this.validaDadosCnpj(json);
  }
  if (json.get("importador") && parseInt(json.get("importador")) > 0 ){
    this.isCadastrado(json);
  }
  
  dadosDefault = this.validaDadosDefault(json);
  return dadosDefault;
};

ValidaFornecedor.prototype.validaDadosDefault = function(json){
  if(!json){
 		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
  }
  if(!json.get("arMercantil") || json.get("arMercantil") === null || json.get("arMercantil") === undefined){
  	json.put("arMercantil", 0);
  }
  if(!json.get("bairroForn") || json.get("bairroForn") === null || json.get("bairroForn") === undefined){
  	json.put("bairroForn", " ");
  }
  if(!json.get("baseIcmsDesc") || json.get("baseIcmsDesc") === null || json.get("baseIcmsDesc") === undefined){
  	json.put("baseIcmsDesc", 0);
  }
  if(!json.get("baseIpiDesc") || json.get("baseIpiDesc") === null || json.get("baseIpiDesc") === undefined){
  	json.put("baseIpiDesc", 0);
  }
  if(!json.get("cargo") || json.get("cargo") === null || json.get("cargo") === undefined){
  	json.put("cargo", " ");
  }
  if(!json.get("cdCid") || json.get("cdCid") === null || json.get("cdCid") === undefined){
  	json.put("cdCid", 0);
  }
  if(!json.get("cdComprador") || json.get("cdComprador") === null || json.get("cdComprador") === undefined){
  	json.put("cdComprador", 0);
  }
  if(!json.get("cdCtbCnt") || json.get("cdCtbCnt") === null || json.get("cdCtbCnt") === undefined){
  	json.put("cdCtbCnt", " ");
  }
  if(!json.get("cdCtbCntRed") || json.get("cdCtbCntRed") === null || json.get("cdCtbCntRed") === undefined){
  	json.put("cdCtbCntRed", 0);
  }
  if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
  	json.put("cdEmp", 1);
  }
  if(!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined){
  	json.put("cdFilial", 0);
  }
  if(!json.get("cdOperMva") || json.get("cdOperMva") === null || json.get("cdOperMva") === undefined){
  	json.put("cdOperMva", 0);
  }
  if(!json.get("cdTpForn") || json.get("cdTpForn") === null || json.get("cdTpForn") === undefined){
  	json.put("cdTpForn", 0);
  }
  if(!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined){
  	json.put("cdUsu", 0);
  }
  if(!json.get("cep") || json.get("cep") === null || json.get("cep") === undefined){
  	json.put("cep", " ");
  }
  if(!json.get("cgcCpf") || json.get("cgcCpf") === null || json.get("cgcCpf") === undefined){
  	json.put("cgcCpf", " ");
  }
  if(!json.get("clasForn") || json.get("clasForn") === null || json.get("clasForn") === undefined){
  	json.put("clasForn", 0);
  }
  if(!json.get("compleEnd") || json.get("compleEnd") === null || json.get("compleEnd") === undefined){
  	json.put("compleEnd", " ");
  }
  if(!json.get("compraEmbalado") || json.get("compraEmbalado") === null || json.get("compraEmbalado") === undefined){
  	json.put("compraEmbalado", 0);
  }
  if(!json.get("compraMultiplo") || json.get("compraMultiplo") === null || json.get("compraMultiplo") === undefined){
  	json.put("compraMultiplo", 0);
  }
  if(!json.get("contato") || json.get("contato") === null || json.get("contato") === undefined){
  	json.put("contato", " ");
  }
  if(!json.get("crt") || json.get("crt") === null || json.get("crt") === undefined){
  	json.put("crt", 3);
  }
  if(!json.get("diaSegu") || json.get("diaSegu") === null || json.get("diaSegu") === undefined){
  	json.put("diaSegu", 0);
  }
  if(!json.get("diaVisita") || json.get("diaVisita") === null || json.get("diaVisita") === undefined){
  	json.put("diaVisita", 0);
  }
  if(!json.get("dtCad") || json.get("dtCad") === null || json.get("dtCad") === undefined){
  	json.put("dtCad", " ");
  }
  if(!json.get("email") || json.get("email") === null || json.get("email") === undefined){
  	json.put("email", " ");
  }
  if(!json.get("endForn") || json.get("endForn") === null || json.get("endForn") === undefined){
  	json.put("endForn", " ");
  }
  if(!json.get("espNf") || json.get("espNf") === null || json.get("espNf") === undefined){
  	json.put("espNf", " ");
  }
  if(!json.get("exigeDanfeAgendamento") || json.get("exigeDanfeAgendamento") === null || json.get("exigeDanfeAgendamento") === undefined){
  	json.put("exigeDanfeAgendamento", 0);
  }
  if(!json.get("exportNfEscrita") || json.get("exportNfEscrita") === null || json.get("exportNfEscrita") === undefined){
  	json.put("exportNfEscrita", 0);
  }
  if(!json.get("fax") || json.get("fax") === null || json.get("fax") === undefined){
  	json.put("fax", " ");
  }
  if(!json.get("flagAbaterDescProdDanfe") || json.get("flagAbaterDescProdDanfe") === null || json.get("flagAbaterDescProdDanfe") === undefined){
  	json.put("flagAbaterDescProdDanfe", 0);
  }
  if(!json.get("flagCdProdFornEan") || json.get("flagCdProdFornEan") === null || json.get("flagCdProdFornEan") === undefined){
  	json.put("flagCdProdFornEan", 0);
  }
  if(!json.get("flagConverteEntradaManual") || json.get("flagConverteEntradaManual") === null || json.get("flagConverteEntradaManual") === undefined){
  	json.put("flagConverteEntradaManual", 0);
  }
  if(!json.get("flagCtrDevo") || json.get("flagCtrDevo") === null || json.get("flagCtrDevo") === undefined){
  	json.put("flagCtrDevo", 0);
  }
  if(!json.get("flagCtrPedForn") || json.get("flagCtrPedForn") === null || json.get("flagCtrPedForn") === undefined){
  	json.put("flagCtrPedForn", 0);
  }
  if(!json.get("flagDescBrutoProdutoXml") || json.get("flagDescBrutoProdutoXml") === null || json.get("flagDescBrutoProdutoXml") === undefined){
  	json.put("flagDescBrutoProdutoXml", 0);
  }
  if(!json.get("flagEntrarNfSemVincPedido") || json.get("flagEntrarNfSemVincPedido") === null || json.get("flagEntrarNfSemVincPedido") === undefined){
  	json.put("flagEntrarNfSemVincPedido", 0);
  }
  if(!json.get("flagFornMicroEmpresa") || json.get("flagFornMicroEmpresa") === null || json.get("flagFornMicroEmpresa") === undefined){
  	json.put("flagFornMicroEmpresa", 0);
  }
  if(!json.get("flagGeraPagarNfe") || json.get("flagGeraPagarNfe") === null || json.get("flagGeraPagarNfe") === undefined){
  	json.put("flagGeraPagarNfe", 0);
  }
  if(!json.get("flagIcmsSubstPagoAnterior") || json.get("flagIcmsSubstPagoAnterior") === null || json.get("flagIcmsSubstPagoAnterior") === undefined){
  	json.put("flagIcmsSubstPagoAnterior", 0);
  }
  if(!json.get("flagIgnorarGeraFinan") || json.get("flagIgnorarGeraFinan") === null || json.get("flagIgnorarGeraFinan") === undefined){
  	json.put("flagIgnorarGeraFinan", 0);
  }
  if(!json.get("flagMovImportacao") || json.get("flagMovImportacao") === null || json.get("flagMovImportacao") === undefined){
  	json.put("flagMovImportacao", 0);
  }
  if(!json.get("flagNaoConverterEmbalagem") || json.get("flagNaoConverterEmbalagem") === null || json.get("flagNaoConverterEmbalagem") === undefined){
  	json.put("flagNaoConverterEmbalagem", 0);
  }
  if(!json.get("flagPermiteEntradaTribDiverge") || json.get("flagPermiteEntradaTribDiverge") === null || json.get("flagPermiteEntradaTribDiverge") === undefined){
  	json.put("flagPermiteEntradaTribDiverge", 0);
  }
  if(!json.get("flagRestrSerie") || json.get("flagRestrSerie") === null || json.get("flagRestrSerie") === undefined){
  	json.put("flagRestrSerie", 0);
  }
  if(!json.get("flagTipoIntegNotaFiscal") || json.get("flagTipoIntegNotaFiscal") === null || json.get("flagTipoIntegNotaFiscal") === undefined){
  	json.put("flagTipoIntegNotaFiscal", 0);
  }
  if(!json.get("flagUtilizaTribGeraDar") || json.get("flagUtilizaTribGeraDar") === null || json.get("flagUtilizaTribGeraDar") === undefined){
  	json.put("flagUtilizaTribGeraDar", 0);
  }
  if(!json.get("flagValidaNfe") || json.get("flagValidaNfe") === null || json.get("flagValidaNfe") === undefined){
  	json.put("flagValidaNfe", 0);
  }
  if(!json.get("fornConcor") || json.get("fornConcor") === null || json.get("fornConcor") === undefined){
  	json.put("fornConcor", 0);
  }
  if(!json.get("freteIncideBaseIcms") || json.get("freteIncideBaseIcms") === null || json.get("freteIncideBaseIcms") === undefined){
  	json.put("freteIncideBaseIcms", 0);
  }
  if(!json.get("freteIncideSubs") || json.get("freteIncideSubs") === null || json.get("freteIncideSubs") === undefined){
  	json.put("freteIncideSubs", 0);
  }
  if(!json.get("ignorarExpContabil") || json.get("ignorarExpContabil") === null || json.get("ignorarExpContabil") === undefined){
  	json.put("ignorarExpContabil", 0);
  }
  if(!json.get("ignorarIpiBaseSubst") || json.get("ignorarIpiBaseSubst") === null || json.get("ignorarIpiBaseSubst") === undefined){
  	json.put("ignorarIpiBaseSubst", 0);
  }
  if(!json.get("inscEst") || json.get("inscEst") === null || json.get("inscEst") === undefined){
  	json.put("inscEst", " ");
  }
  if(!json.get("inscMuni") || json.get("inscMuni") === null || json.get("inscMuni") === undefined){
  	json.put("inscMuni", " ");
  }
  if(!json.get("lcArqGerRecFidelize") || json.get("lcArqGerRecFidelize") === null || json.get("lcArqGerRecFidelize") === undefined){
  	json.put("lcArqGerRecFidelize", " ");
  }
  if(!json.get("leadTime") || json.get("leadTime") === null || json.get("leadTime") === undefined){
  	json.put("leadTime", 0);
  }
  if(!json.get("nmFant") || json.get("nmFant") === null || json.get("nmFant") === undefined){
  	json.put("nmFant", " ");
  }
  if(!json.get("nrEndForn") || json.get("nrEndForn") === null || json.get("nrEndForn") === undefined){
  	json.put("nrEndForn", 0);
  }
  if(!json.get("obs") || json.get("obs") === null || json.get("obs") === undefined){
  	json.put("obs", " ");
  }
  if(!json.get("outrosBaseIcms") || json.get("outrosBaseIcms") === null || json.get("outrosBaseIcms") === undefined){
  	json.put("outrosBaseIcms", 0);
  }
  if(!json.get("percIcmsSimples") || json.get("percIcmsSimples") === null || json.get("percIcmsSimples") === undefined){
  	json.put("percIcmsSimples", 0);
  }
  if(!json.get("percIcmsSubs") || json.get("percIcmsSubs") === null || json.get("percIcmsSubs") === undefined){
  	json.put("percIcmsSubs", 0);
  }
  if(!json.get("percIpiBaseIcms") || json.get("percIpiBaseIcms") === null || json.get("percIpiBaseIcms") === undefined){
  	json.put("percIpiBaseIcms", 0);
  }
  if(!json.get("percMaximoOutrasDespesasProdutos") || json.get("percMaximoOutrasDespesasProdutos") === null || json.get("percMaximoOutrasDespesasProdutos") === undefined){
  	json.put("percMaximoOutrasDespesasProdutos", 0);
  }
  if(!json.get("percRed") || json.get("percRed") === null || json.get("percRed") === undefined){
  	json.put("percRed", 0);
  }
  if(!json.get("percReduBasePmc") || json.get("percReduBasePmc") === null || json.get("percReduBasePmc") === undefined){
  	json.put("percReduBasePmc", 0);
  }
  if(!json.get("periodc") || json.get("periodc") === null || json.get("periodc") === undefined){
  	json.put("periodc", 0);
  }
  if(!json.get("pessoa") || json.get("pessoa") === null || json.get("pessoa") === undefined){
  	json.put("pessoa", 0);
  }
  if(!json.get("precoBaseSubs") || json.get("precoBaseSubs") === null || json.get("precoBaseSubs") === undefined){
  	json.put("precoBaseSubs", 0);
  }
  if(!json.get("procPrecificacao") || json.get("procPrecificacao") === null || json.get("procPrecificacao") === undefined){
  	json.put("procPrecificacao", 0);
  }
  if(!json.get("przEntr") || json.get("przEntr") === null || json.get("przEntr") === undefined){
  	json.put("przEntr", 0);
  }
  if(!json.get("qtdeCasasDecimaisNota") || json.get("qtdeCasasDecimaisNota") === null || json.get("qtdeCasasDecimaisNota") === undefined){
  	json.put("qtdeCasasDecimaisNota", 0);
  }
  if(!json.get("red") || json.get("red") === null || json.get("red") === undefined){
  	json.put("red", 0);
  }
  if(!json.get("rzForn") || json.get("rzForn") === null || json.get("rzForn") === undefined){
  	json.put("rzForn", " ");
  }
  if(!json.get("serieNf") || json.get("serieNf") === null || json.get("serieNf") === undefined){
  	json.put("serieNf", " ");
  }
  if(!json.get("stsForn") || json.get("stsForn") === null || json.get("stsForn") === undefined){
  	json.put("stsForn", 0);
  }
  if(!json.get("subsDesc") || json.get("subsDesc") === null || json.get("subsDesc") === undefined){
  	json.put("subsDesc", 0);
  }
  if(!json.get("subsTrib") || json.get("subsTrib") === null || json.get("subsTrib") === undefined){
  	json.put("subsTrib", 0);
  }
  if(!json.get("tel") || json.get("tel") === null || json.get("tel") === undefined){
  	json.put("tel", " ");
  }
  if(!json.get("tipoFrete") || json.get("tipoFrete") === null || json.get("tipoFrete") === undefined){
  	json.put("tipoFrete", 0);
  }
  if(!json.get("tpFaturamento") || json.get("tpFaturamento") === null || json.get("tpFaturamento") === undefined){
  	json.put("tpFaturamento", 0);
  }
  if(!json.get("tpLayoutExpEnt") || json.get("tpLayoutExpEnt") === null || json.get("tpLayoutExpEnt") === undefined){
  	json.put("tpLayoutExpEnt", 0);
  }
  if(!json.get("tpLayoutPedEletr") || json.get("tpLayoutPedEletr") === null || json.get("tpLayoutPedEletr") === undefined){
  	json.put("tpLayoutPedEletr", 0);
  }
  if(!json.get("tpSubsTrib") || json.get("tpSubsTrib") === null || json.get("tpSubsTrib") === undefined){
  	json.put("tpSubsTrib", 0);
  }
  if(!json.get("flagImportaMcc") || json.get("flagImportaMcc") === null || json.get("flagImportaMcc") === undefined){
  	json.put("flagImportaMcc", 0);
  }

  return json;
}

ValidaFornecedor.prototype.validaCadastrado = function(json){
  if(!json){
 		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
 	}
  forn  =   this.mapper.selectOne("PgForn.listarPgForn",json);
  if(!forn) {
      throw {code: 599, message: "Fornecedor "  + json.get("cdForn") + " nao cadastrado."};
  }else {
      if(fornecedor.get("stsForn") > 0 ){
          throw {code: 599, message: "Fornecedor " + json.get("cdForn") + ' - '+ forn.get("rzForn") + ' inativo.'};
      }
  }
}

ValidaFornecedor.prototype.validaDadosCnpj = function(json){
  if(!json){
 		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
 	}
  if(json.get("cgcCpf")){
    if(validarCNPJ(json.get("cgcCpf")) === false ){
        throw {code: 599, message: "CNPJ " +  json.get("cgcCpf") + " inválido."};
    }
  }
};

ValidaFornecedor.prototype.isCadastrado = function(json){
  if(!json){
 		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
 	}
 	if(json.get("cdForn")){
     	variaveis        = {};
     	variaveis.cdForn = json.get("cdForn");
        forn  =   this.mapper.selectOne("PgForn.listarPgForn",variaveis);
        if(forn){
            throw {code: 599, message: "Fornecedor " +  json.get("cdForn") + " já Cadastrado."};
        }
 	}
    if(json.get("cgcCpf") && json.get("cgcCpf").length() > 12){
        variaveis1        = {};
     	variaveis1.cgcCpf = json.get("cgcCpf");
        forn1  =   this.mapper.selectOne("PgForn.listarPgForn",variaveis1);
        if(forn1){
            throw {code: 599, message: "Fornecedor " +  json.get("cgcCpf") + " já Cadastrado."};
        }
    }
};
