/**
 * Created by maurodouglas on 01/11/16.
 */
load('/basicos/validaCpfCnpj.js');
var ValidaFilial = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "PrcFilial", "PrcFilialConfig" ]);
};

ValidaFilial.prototype.validaDadosFilial = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	var variaveis = {};
	variaveis.cdFilial = json.get( "cdFilial" );
	var filial = this.mapper.selectOne( "PrcFilial.listarPrcFilial", variaveis );
	if ( !filial ) {
		throw {
			code: 599,
			message: 'Filial ' + json.get( "cdFilial" ) + ' nao cadastrada.'
		};
	} else {
		if ( filial.get( "stsFilial" ) > 0 ) {
			throw {
				code: 599,
				message: 'Filial ' + json.get( "cdFilial" ) + ' - ' + filial.get( "rzFilial" ) + ' inativa.'
			};
		}
		if (!filial.get( "dtIniSistema" )) {
			throw {
				code: 599,
				message: 'Filial ' + json.get( "cdFilial" ) + ' - ' + filial.get( "rzFilial" ) + ' com data de inicio de sistema não definida- PRC_FILIAL.DT_INI_SISTEMA.'
			};
		}
	}

	return filial;

};

ValidaFilial.prototype.validaDadosFilialByJSON = function( json ) {
	if ( !json ) {
		return { error: true, code: 599, message: "Dados passados ao servidor inválido!" };
	}
	
	var mapper = mapperFactory.createMapperMult([ "PrcFilial", "PrcFilialConfig" ]);
	
	try{
    	var variaveis = {};
    	variaveis.cdEmp    = json.cdEmp;
    	variaveis.cdFilial = json.cdFilial;
    	var filial = mapper.selectOne( "PrcFilial.isValidPrcFilial", variaveis );
    	if ( !filial ) {
    		return { 
    		    error: true,
    			code: 599,
    			message: 'Filial ' + json.cdFilial + ' nao cadastrada.'
    		};
    	} else {
    		if ( filial.get( "stsFilial" ) > 0 ) {
    			return { 
    			    error: true,
    				code: 599,
    				message: 'Filial ' + json.cdFilial + ' - ' + filial.get( "rzFilial" ) + ' inativa.'
    			};
    		}
    		if (!filial.get( "dtIniSistema" )) {
    			return { 
    			    error: true,
    				code: 599,
    				message: 'Filial ' + json.cdFilial + ' - ' + filial.get( "rzFilial" ) + ' com data de inicio de sistema não definida- PRC_FILIAL.DT_INI_SISTEMA.'
    			};
    		}
    	}
    	return filial;
	}finally{
	    mapper.close();
	}	

};

/**
  * Metodo valida os dados enviados para o cadasto da filial,
  * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
  * @throws {InvalidArgumentException}
  */

ValidaFilial.prototype.validaDadosParaCadastro = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

  if (json.get( "cgc") !== null && !validarCNPJ(json.get("cgc"))) {
    throw { code: 599, message: "CNPJ " + json.get("cgc") + " informado no cadastro não é um CNPJ Valido!" };
  }
  if (json.get( "cgc") !== null && this.isFilialJaCadastrada({'cgc': json.get( "cgc" )})) {
		throw { code: 599, message: "Filial " + json.get("cdFilial") + ' - ' + json.get("rzFilial") + " já cadastrada!" };
	}

	if (json.get( "cliente" )){
    	if( json.get( "cliente" ).get( "cdCli" ) !== null && this.isClienteJaVinculado({'cdEmp': json.get( "cdEmp" ), 'cdCli': json.get( "cliente" ).get( "cdCli" )})) {
    		throw { code: 599, message: "Cliente já está vinculado a outra filial!" };
    	}
	}

	if (json.get( "fornecedor" )){
	    if( json.get( "fornecedor" ).get( "cdForn" ) !== null && this.isFornecedorJaVinculado({'cdEmp': json.get( "cdEmp" ), 'cdForn': json.get( "fornecedor" ).get( "cdForn" )})) {
		    throw { code: 599, message: "Fornecedor já está vinculado a outra filial!" };
	    }
	}

  var dadosDefault = this.dadosDefault(json);
  return dadosDefault;
};

/**
  * Metodo valida se já esta cadastrada no sistema
  * @param {HashMap JAVA} json - CNPJ da Filial
  * @throws {InvalidArgumentException}
  */
ValidaFilial.prototype.isFilialJaCadastrada = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	var filial = this.mapper.selectOne( "PrcFilial.listarPrcFilial", json );
	return ( filial ? true : false );
};

/**
  * Metodo valida se cliente está habilitado para realizar vinculo com a filial,
  * sendo que um cliente pode estar vinculado apenas a uma filial
  * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
  * @throws {InvalidArgumentException}
  */
ValidaFilial.prototype.isClienteJaVinculado = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	var cliente = this.mapper.selectOne( "PrcFilialRcCli.listarPrcFilialRcCli", json );
	return ( cliente ? true : false );
};

/**
  * Metodo valida se fornecedor está habilitado para realizar vinculo com a filial,
  * sendo que um fornecedor pode estar vinculado apenas a uma filial
  * @param {HashMap JAVA} json - parametro de código de empresa e fornecedor passados no momento da requisicao
  * @throws {InvalidArgumentException}
  */
ValidaFilial.prototype.isFornecedorJaVinculado = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	var fornecedor = this.mapper.selectOne( "PrcFilialPgForn.listarPrcFilialPgForn", json );
	return ( fornecedor ? true : false );
};

/**
  * Metodo valida os dados enviados e coloca os valores default esperado pelo o banco para os registros nao enviados
  * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
  * @throws {InvalidArgumentException}
  * @return retorna um objeto com os dados default validados
  */

ValidaFilial.prototype.dadosDefault = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	if ( !json.get( "aliqIcms" ) || json.get( "aliqIcms" ) === null || json.get( "aliqIcms" ) === undefined ) {
		json.put("aliqIcms", 0);
	}
	if ( !json.get( "area" ) || json.get( "area" ) === null || json.get( "area" ) === undefined ) {
		json.put("area", 0);
	}
	if ( !json.get( "areaCusto" ) || json.get( "areaCusto" ) === null || json.get( "areaCusto" ) === undefined ) {
		json.put("areaCusto", 0);
	}
	if ( !json.get( "areaFarma" ) || json.get( "areaFarma" ) === null || json.get( "areaFarma" ) === undefined ) {
		json.put("areaFarma", 0);
	}
	if ( !json.get( "areaNaoFarma" ) || json.get( "areaNaoFarma" ) === null || json.get( "areaNaoFarma" ) === undefined ) {
		json.put("areaNaoFarma", 0);
	}
	if ( !json.get( "areaOutros" ) || json.get( "areaOutros" ) === null || json.get( "areaOutros" ) === undefined ) {
		json.put("areaOutros", 0);
	}
	if ( !json.get( "bairro" ) || json.get( "bairro" ) === null || json.get( "bairro" ) === undefined ) {
		json.put("bairro", " ");
	}
	if ( !json.get( "blqDescPgtoPrazo" ) || json.get( "blqDescPgtoPrazo" ) === null || json.get( "blqDescPgtoPrazo" ) === undefined ) {
		json.put("blqDescPgtoPrazo", 0);
	}
	if ( !json.get( "bxEstNfDevAvulsa" ) || json.get( "bxEstNfDevAvulsa" ) === null || json.get( "bxEstNfDevAvulsa" ) === undefined ) {
		json.put("bxEstNfDevAvulsa", 0);
	}
	if ( !json.get( "cdBc" ) || json.get( "cdBc" ) === null || json.get( "cdBc" ) === undefined ) {
		json.put("cdBc", " ");
	}
	if ( !json.get( "cdCentroCustoContabil" ) || json.get( "cdCentroCustoContabil" ) === null || json.get( "cdCentroCustoContabil" ) === undefined ) {
		json.put("cdCentroCustoContabil", " ");
	}
	if ( !json.get( "cdCid" ) || json.get( "cdCid" ) === null || json.get( "cdCid" ) === undefined ) {
		json.put("cdCid", 0);
	}
	if ( !json.get( "cdEmp" ) || json.get( "cdEmp" ) === null || json.get( "cdEmp" ) === undefined ) {
		json.put("cdEmp", 1);
	}
	if ( !json.get( "cdEmpresaContabil" ) || json.get( "cdEmpresaContabil" ) === null || json.get( "cdEmpresaContabil" ) === undefined ) {
		json.put("cdEmpresaContabil", " ");
	}
	if ( !json.get( "cdFilial" ) || json.get( "cdFilial" ) === null || json.get( "cdFilial" ) === undefined ) {
		json.put("cdFilial", 0);
	}
	if ( !json.get( "cdFilialContab" ) || json.get( "cdFilialContab" ) === null || json.get( "cdFilialContab" ) === undefined ) {
		json.put("cdFilialContab", 0);
	}
	if ( !json.get( "cdModCfSpedFiscal" ) || json.get( "cdModCfSpedFiscal" ) === null || json.get( "cdModCfSpedFiscal" ) === undefined ) {
		json.put("cdModCfSpedFiscal", 0);
	}
	if ( !json.get( "cdOperMva" ) || json.get( "cdOperMva" ) === null || json.get( "cdOperMva" ) === undefined ) {
		json.put("cdOperMva", 0);
	}
	if ( !json.get( "cdPerfil" ) || json.get( "cdPerfil" ) === null || json.get( "cdPerfil" ) === undefined ) {
		json.put("cdPerfil", 0);
	}
	if ( !json.get( "cdUsu" ) || json.get( "cdUsu" ) === null || json.get( "cdUsu" ) === undefined ) {
		json.put("cdUsu", 1);
	}
	if ( !json.get( "cep" ) || json.get( "cep" ) === null || json.get( "cep" ) === undefined ) {
		json.put("cep", " ");
	}
	if ( !json.get( "cgc" ) || json.get( "cgc" ) === null || json.get( "cgc" ) === undefined ) {
		json.put("cgc", " ");
	}
	if ( !json.get( "cgcCpfResp" ) || json.get( "cgcCpfResp" ) === null || json.get( "cgcCpfResp" ) === undefined ) {
		json.put("cgcCpfResp", " ");
	}
	if ( !json.get( "complemento" ) || json.get( "complemento" ) === null || json.get( "complemento" ) === undefined ) {
		json.put("complemento", " ");
	}
	if ( !json.get( "consultoraDermo" ) || json.get( "consultoraDermo" ) === null || json.get( "consultoraDermo" ) === undefined ) {
		json.put("consultoraDermo", 0);
	}
	if ( !json.get( "convProdEnt" ) || json.get( "convProdEnt" ) === null || json.get( "convProdEnt" ) === undefined ) {
		json.put("convProdEnt", 0);
	}
	if ( !json.get( "ctrFormContinuo" ) || json.get( "ctrFormContinuo" ) === null || json.get( "ctrFormContinuo" ) === undefined ) {
		json.put("ctrFormContinuo", 0);
	}
	if ( !json.get( "ctrLote" ) || json.get( "ctrLote" ) === null || json.get( "ctrLote" ) === undefined ) {
		json.put("ctrLote", 0);
	}
	if ( !json.get( "ctrMeta" ) || json.get( "ctrMeta" ) === null || json.get( "ctrMeta" ) === undefined ) {
		json.put("ctrMeta", 0);
	}
	if ( !json.get( "ctrSeloNotaSaida" ) || json.get( "ctrSeloNotaSaida" ) === null || json.get( "ctrSeloNotaSaida" ) === undefined ) {
		json.put("ctrSeloNotaSaida", 0);
	}
	if ( !json.get( "dataSyncServ" ) || json.get( "dataSyncServ" ) === null || json.get( "dataSyncServ" ) === undefined ) {
		json.put("dataSyncServ", 0);
	}
	if ( !json.get( "ddProts" ) || json.get( "ddProts" ) === null || json.get( "ddProts" ) === undefined ) {
		json.put("ddProts", 0);
	}
	if ( !json.get( "dsSiglaFilialCp" ) || json.get( "dsSiglaFilialCp" ) === null || json.get( "dsSiglaFilialCp" ) === undefined ) {
		json.put("dsSiglaFilialCp", " ");
	}
	if ( !json.get( "email" ) || json.get( "email" ) === null || json.get( "email" ) === undefined ) {
		json.put("email", " ");
	}
	if ( !json.get( "endArqCarga" ) || json.get( "endArqCarga" ) === null || json.get( "endArqCarga" ) === undefined ) {
		json.put("endArqCarga", " ");
	}
	if ( !json.get( "endArqOrc" ) || json.get( "endArqOrc" ) === null || json.get( "endArqOrc" ) === undefined ) {
		json.put("endArqOrc", " ");
	}
	if ( !json.get( "endArqOrcLinux" ) || json.get( "endArqOrcLinux" ) === null || json.get( "endArqOrcLinux" ) === undefined ) {
		json.put("endArqOrcLinux", " ");
	}
	if ( !json.get( "endFililal" ) || json.get( "endFililal" ) === null || json.get( "endFililal" ) === undefined ) {
		json.put("endFililal", " ");
	}
	if ( !json.get( "espNf" ) || json.get( "espNf" ) === null || json.get( "espNf" ) === undefined ) {
		json.put("espNf", " ");
	}
	if ( !json.get( "especieFilial" ) || json.get( "especieFilial" ) === null || json.get( "especieFilial" ) === undefined ) {
		json.put("especieFilial", 0);
	}
	if ( !json.get( "fax" ) || json.get( "fax" ) === null || json.get( "fax" ) === undefined ) {
		json.put("fax", " ");
	}
	if ( !json.get( "filialCopiaMtz" ) || json.get( "filialCopiaMtz" ) === null || json.get( "filialCopiaMtz" ) === undefined ) {
		json.put("filialCopiaMtz", 0);
	}
	if ( !json.get( "filialDepositoAux" ) || json.get( "filialDepositoAux" ) === null || json.get( "filialDepositoAux" ) === undefined ) {
		json.put("filialDepositoAux", 0);
	}
	if ( !json.get( "filialMtz" ) || json.get( "filialMtz" ) === null || json.get( "filialMtz" ) === undefined ) {
		json.put("filialMtz", 0);
	}
	if ( !json.get( "filialMtzGrpEcon" ) || json.get( "filialMtzGrpEcon" ) === null || json.get( "filialMtzGrpEcon" ) === undefined ) {
		json.put("filialMtzGrpEcon", 0);
	}
	if ( !json.get( "flagCarga" ) || json.get( "flagCarga" ) === null || json.get( "flagCarga" ) === undefined ) {
		json.put("flagCarga", 0);
	}
	if ( !json.get( "flagCheckinEntradaVolume" ) || json.get( "flagCheckinEntradaVolume" ) === null || json.get( "flagCheckinEntradaVolume" ) === undefined ) {
		json.put("flagCheckinEntradaVolume", 0);
	}
	if ( !json.get( "flagCons" ) || json.get( "flagCons" ) === null || json.get( "flagCons" ) === undefined ) {
		json.put("flagCons", 0);
	}
	if ( !json.get( "flagConsTelevendas" ) || json.get( "flagConsTelevendas" ) === null || json.get( "flagConsTelevendas" ) === undefined ) {
		json.put("flagConsTelevendas", 0);
	}
	if ( !json.get( "flagConsolidadorAtivo" ) || json.get( "flagConsolidadorAtivo" ) === null || json.get( "flagConsolidadorAtivo" ) === undefined ) {
		json.put("flagConsolidadorAtivo", 0);
	}
	if ( !json.get( "flagDescVlr" ) || json.get( "flagDescVlr" ) === null || json.get( "flagDescVlr" ) === undefined ) {
		json.put("flagDescVlr", 0);
	}
	if ( !json.get( "flagFaturamentoAutomaticoHabilitado" ) || json.get( "flagFaturamentoAutomaticoHabilitado" ) === null || json.get( "flagFaturamentoAutomaticoHabilitado" ) === undefined ) {
		json.put("flagFaturamentoAutomaticoHabilitado", 0);
	}
	if ( !json.get( "flagFilialFranquia" ) || json.get( "flagFilialFranquia" ) === null || json.get( "flagFilialFranquia" ) === undefined ) {
		json.put("flagFilialFranquia", 0);
	}
	if ( !json.get( "flagFilialNaoParticpMix" ) || json.get( "flagFilialNaoParticpMix" ) === null || json.get( "flagFilialNaoParticpMix" ) === undefined ) {
		json.put("flagFilialNaoParticpMix", 0);
	}
	if ( !json.get( "flagIgnorarExcessoSuprimento" ) || json.get( "flagIgnorarExcessoSuprimento" ) === null || json.get( "flagIgnorarExcessoSuprimento" ) === undefined ) {
		json.put("flagIgnorarExcessoSuprimento", 0);
	}
	if ( !json.get( "flagIgnorarPontuacao" ) || json.get( "flagIgnorarPontuacao" ) === null || json.get( "flagIgnorarPontuacao" ) === undefined ) {
		json.put("flagIgnorarPontuacao", 0);
	}
	if ( !json.get( "flagNaoParticIndic" ) || json.get( "flagNaoParticIndic" ) === null || json.get( "flagNaoParticIndic" ) === undefined ) {
		json.put("flagNaoParticIndic", 0);
	}
	if ( !json.get( "flagNaoReporPbm" ) || json.get( "flagNaoReporPbm" ) === null || json.get( "flagNaoReporPbm" ) === undefined ) {
		json.put("flagNaoReporPbm", 0);
	}
	if ( !json.get( "flagNfeHabilitada" ) || json.get( "flagNfeHabilitada" ) === null || json.get( "flagNfeHabilitada" ) === undefined ) {
		json.put("flagNfeHabilitada", 0);
	}
	if ( !json.get( "flagNotaFiscalEntradaAutomatica" ) || json.get( "flagNotaFiscalEntradaAutomatica" ) === null || json.get( "flagNotaFiscalEntradaAutomatica" ) === undefined ) {
		json.put("flagNotaFiscalEntradaAutomatica", 0);
	}
	if ( !json.get( "flagOperadorLog" ) || json.get( "flagOperadorLog" ) === null || json.get( "flagOperadorLog" ) === undefined ) {
		json.put("flagOperadorLog", 0);
	}
	if ( !json.get( "flagSngpcHabilitado" ) || json.get( "flagSngpcHabilitado" ) === null || json.get( "flagSngpcHabilitado" ) === undefined ) {
		json.put("flagSngpcHabilitado", 0);
	}
	if ( !json.get( "flagSomCheckOut" ) || json.get( "flagSomCheckOut" ) === null || json.get( "flagSomCheckOut" ) === undefined ) {
		json.put("flagSomCheckOut", 0);
	}
	if ( !json.get( "flagTipoGeracaoCustoIcmsCredito" ) || json.get( "flagTipoGeracaoCustoIcmsCredito" ) === null || json.get( "flagTipoGeracaoCustoIcmsCredito" ) === undefined ) {
		json.put("flagTipoGeracaoCustoIcmsCredito", 0);
	}
	if ( !json.get( "flagTpImp" ) || json.get( "flagTpImp" ) === null || json.get( "flagTpImp" ) === undefined ) {
		json.put("flagTpImp", 0);
	}
	if ( !json.get( "flagTpOrc" ) || json.get( "flagTpOrc" ) === null || json.get( "flagTpOrc" ) === undefined ) {
		json.put("flagTpOrc", 0);
	}
	if ( !json.get( "flagTpReqLoja" ) || json.get( "flagTpReqLoja" ) === null || json.get( "flagTpReqLoja" ) === undefined ) {
		json.put("flagTpReqLoja", 0);
	}
	if ( !json.get( "flagTpRessuprimento" ) || json.get( "flagTpRessuprimento" ) === null || json.get( "flagTpRessuprimento" ) === undefined ) {
		json.put("flagTpRessuprimento", 0);
	}
	if ( !json.get( "flagValidarNotaEntradaForn" ) || json.get( "flagValidarNotaEntradaForn" ) === null || json.get( "flagValidarNotaEntradaForn" ) === undefined ) {
		json.put("flagValidarNotaEntradaForn", 0);
	}
	if ( !json.get( "flagtiralojaar" ) || json.get( "flagtiralojaar" ) === null || json.get( "flagtiralojaar" ) === undefined ) {
		json.put("flagtiralojaar", 0);
	}
	if ( !json.get( "flagvintequatrohoras" ) || json.get( "flagvintequatrohoras" ) === null || json.get( "flagvintequatrohoras" ) === undefined ) {
		json.put("flagvintequatrohoras", 0);
	}
	if ( !json.get( "geraArqPed" ) || json.get( "geraArqPed" ) === null || json.get( "geraArqPed" ) === undefined ) {
		json.put("geraArqPed", 0);
	}
	if ( !json.get( "gerentes" ) || json.get( "gerentes" ) === null || json.get( "gerentes" ) === undefined ) {
		json.put("gerentes", " ");
	}
	if ( !json.get( "ignoraImpostoNfEnt" ) || json.get( "ignoraImpostoNfEnt" ) === null || json.get( "ignoraImpostoNfEnt" ) === undefined ) {
		json.put("ignoraImpostoNfEnt", 0);
	}
	if ( !json.get( "infRed" ) || json.get( "infRed" ) === null || json.get( "infRed" ) === undefined ) {
		json.put("infRed", " ");
	}
	if ( !json.get( "inscEst" ) || json.get( "inscEst" ) === null || json.get( "inscEst" ) === undefined ) {
		json.put("inscEst", " ");
	}
	if ( !json.get( "inscMuni" ) || json.get( "inscMuni" ) === null || json.get( "inscMuni" ) === undefined ) {
		json.put("inscMuni", " ");
	}
	if ( !json.get( "ipServBd" ) || json.get( "ipServBd" ) === null || json.get( "ipServBd" ) === undefined ) {
		json.put("ipServBd", " ");
	}
	if ( !json.get( "ipServFilial" ) || json.get( "ipServFilial" ) === null || json.get( "ipServFilial" ) === undefined ) {
		json.put("ipServFilial", " ");
	}
	if ( !json.get( "metragem" ) || json.get( "metragem" ) === null || json.get( "metragem" ) === undefined ) {
		json.put("metragem", 0);
	}
	if ( !json.get( "moraBol" ) || json.get( "moraBol" ) === null || json.get( "moraBol" ) === undefined ) {
		json.put("moraBol", 0);
	}
	if ( !json.get( "nmFant" ) || json.get( "nmFant" ) === null || json.get( "nmFant" ) === undefined ) {
		json.put("nmFant", " ");
	}
	if ( !json.get( "nmOdbcPostgres" ) || json.get( "nmOdbcPostgres" ) === null || json.get( "nmOdbcPostgres" ) === undefined ) {
		json.put("nmOdbcPostgres", " ");
	}
	if ( !json.get( "nmOdbcPostgresUsuario" ) || json.get( "nmOdbcPostgresUsuario" ) === null || json.get( "nmOdbcPostgresUsuario" ) === undefined ) {
		json.put("nmOdbcPostgresUsuario", " ");
	}
	if ( !json.get( "nrLicenca" ) || json.get( "nrLicenca" ) === null || json.get( "nrLicenca" ) === undefined ) {
		json.put("nrLicenca", " ");
	}
	if ( !json.get( "numArqRem" ) || json.get( "numArqRem" ) === null || json.get( "numArqRem" ) === undefined ) {
		json.put("numArqRem", 0);
	}
	if ( !json.get( "nvPdv" ) || json.get( "nvPdv" ) === null || json.get( "nvPdv" ) === undefined ) {
		json.put("nvPdv", 0);
	}
	if ( !json.get( "ordemLstFilial" ) || json.get( "ordemLstFilial" ) === null || json.get( "ordemLstFilial" ) === undefined ) {
		json.put("ordemLstFilial", 0);
	}
	if ( !json.get( "percCustoFixo" ) || json.get( "percCustoFixo" ) === null || json.get( "percCustoFixo" ) === undefined ) {
		json.put("percCustoFixo", 0);
	}
	if ( !json.get( "percDescTeleEnt" ) || json.get( "percDescTeleEnt" ) === null || json.get( "percDescTeleEnt" ) === undefined ) {
		json.put("percDescTeleEnt", 0);
	}
	if ( !json.get( "percDescVenda" ) || json.get( "percDescVenda" ) === null || json.get( "percDescVenda" ) === undefined ) {
		json.put("percDescVenda", 0);
	}
	if ( !json.get( "percIr" ) || json.get( "percIr" ) === null || json.get( "percIr" ) === undefined ) {
		json.put("percIr", 0);
	}
	if ( !json.get( "percIss" ) || json.get( "percIss" ) === null || json.get( "percIss" ) === undefined ) {
		json.put("percIss", 0);
	}
	if ( !json.get( "percRed" ) || json.get( "percRed" ) === null || json.get( "percRed" ) === undefined ) {
		json.put("percRed", 0);
	}
	if ( !json.get( "perfilSpedFiscal" ) || json.get( "perfilSpedFiscal" ) === null || json.get( "perfilSpedFiscal" ) === undefined ) {
		json.put("perfilSpedFiscal", "A");
	}
	if ( !json.get( "poloDistr" ) || json.get( "poloDistr" ) === null || json.get( "poloDistr" ) === undefined ) {
		json.put("poloDistr", 0);
	}
	if ( !json.get( "prevEntg" ) || json.get( "prevEntg" ) === null || json.get( "prevEntg" ) === undefined ) {
		json.put("prevEntg", " ");
	}
	if ( !json.get( "prodDiaria" ) || json.get( "prodDiaria" ) === null || json.get( "prodDiaria" ) === undefined ) {
		json.put("prodDiaria", 0);
	}
	if ( !json.get( "prots" ) || json.get( "prots" ) === null || json.get( "prots" ) === undefined ) {
		json.put("prots", 0);
	}
	if ( !json.get( "qtItNf" ) || json.get( "qtItNf" ) === null || json.get( "qtItNf" ) === undefined ) {
		json.put("qtItNf", 0);
	}
	if ( !json.get( "qtItOs" ) || json.get( "qtItOs" ) === null || json.get( "qtItOs" ) === undefined ) {
		json.put("qtItOs", 0);
	}
	if ( !json.get( "qtServNf" ) || json.get( "qtServNf" ) === null || json.get( "qtServNf" ) === undefined ) {
		json.put("qtServNf", 0);
	}
	if ( !json.get( "qtdeGondolas" ) || json.get( "qtdeGondolas" ) === null || json.get( "qtdeGondolas" ) === undefined ) {
		json.put("qtdeGondolas", 0);
	}
	if ( !json.get( "qtdeModulosCategoria" ) || json.get( "qtdeModulosCategoria" ) === null || json.get( "qtdeModulosCategoria" ) === undefined ) {
		json.put("qtdeModulosCategoria", 0);
	}
	if ( !json.get( "qtdePontaGondolas" ) || json.get( "qtdePontaGondolas" ) === null || json.get( "qtdePontaGondolas" ) === undefined ) {
		json.put("qtdePontaGondolas", 0);
	}
	if ( !json.get( "recAtr" ) || json.get( "recAtr" ) === null || json.get( "recAtr" ) === undefined ) {
		json.put("recAtr", 0);
	}
	if ( !json.get( "redBaseIcms" ) || json.get( "redBaseIcms" ) === null || json.get( "redBaseIcms" ) === undefined ) {
		json.put("redBaseIcms", 0);
	}
	if ( !json.get( "refPesqProdMov" ) || json.get( "refPesqProdMov" ) === null || json.get( "refPesqProdMov" ) === undefined ) {
		json.put("refPesqProdMov", 0);
	}
	if ( !json.get( "refPreco" ) || json.get( "refPreco" ) === null || json.get( "refPreco" ) === undefined ) {
		json.put("refPreco", 0);
	}
	if ( !json.get( "regAlterado" ) || json.get( "regAlterado" ) === null || json.get( "regAlterado" ) === undefined ) {
		json.put("regAlterado", 0);
	}
	if ( !json.get( "resp" ) || json.get( "resp" ) === null || json.get( "resp" ) === undefined ) {
		json.put("resp", " ");
	}
	if ( !json.get( "rotImpBol" ) || json.get( "rotImpBol" ) === null || json.get( "rotImpBol" ) === undefined ) {
		json.put("rotImpBol", 0);
	}
	if ( !json.get( "rotImpNf" ) || json.get( "rotImpNf" ) === null || json.get( "rotImpNf" ) === undefined ) {
		json.put("rotImpNf", 0);
	}
	if ( !json.get( "rzFilial" ) || json.get( "rzFilial" ) === null || json.get( "rzFilial" ) === undefined ) {
		json.put("rzFilial", " ");
	}
	if ( !json.get( "senhaUsuPharmalink" ) || json.get( "senhaUsuPharmalink" ) === null || json.get( "senhaUsuPharmalink" ) === undefined ) {
		json.put("senhaUsuPharmalink", " ");
	}
	if ( !json.get( "srNf" ) || json.get( "srNf" ) === null || json.get( "srNf" ) === undefined ) {
		json.put("srNf", " ");
	}
	if ( !json.get( "stsFilial" ) || json.get( "stsFilial" ) === null || json.get( "stsFilial" ) === undefined ) {
		json.put("stsFilial", 0);
	}
	if ( !json.get( "tamanho" ) || json.get( "tamanho" ) === null || json.get( "tamanho" ) === undefined ) {
		json.put("tamanho", 0);
	}
	if ( !json.get( "tel" ) || json.get( "tel" ) === null || json.get( "tel" ) === undefined ) {
		json.put("tel", " ");
	}
	if ( !json.get( "teleNovo" ) || json.get( "teleNovo" ) === null || json.get( "teleNovo" ) === undefined ) {
		json.put("teleNovo", 0);
	}
	if ( !json.get( "tpEmiNf" ) || json.get( "tpEmiNf" ) === null || json.get( "tpEmiNf" ) === undefined ) {
		json.put("tpEmiNf", 0);
	}
	if ( !json.get( "tpFilial" ) || json.get( "tpFilial" ) === null || json.get( "tpFilial" ) === undefined ) {
		json.put("tpFilial", 0);
	}
	if ( !json.get( "tpLanctoChq" ) || json.get( "tpLanctoChq" ) === null || json.get( "tpLanctoChq" ) === undefined ) {
		json.put("tpLanctoChq", 0);
	}
	if ( !json.get( "tpPrecoProd" ) || json.get( "tpPrecoProd" ) === null || json.get( "tpPrecoProd" ) === undefined ) {
		json.put("tpPrecoProd", 0);
	}
	if ( !json.get( "tpRotinaEmisNf" ) || json.get( "tpRotinaEmisNf" ) === null || json.get( "tpRotinaEmisNf" ) === undefined ) {
		json.put("tpRotinaEmisNf", 0);
	}
	if ( !json.get( "vdEstZerado" ) || json.get( "vdEstZerado" ) === null || json.get( "vdEstZerado" ) === undefined ) {
		json.put("vdEstZerado", 0);
	}
	if ( !json.get( "vlrLimitDifCx" ) || json.get( "vlrLimitDifCx" ) === null || json.get( "vlrLimitDifCx" ) === undefined ) {
		json.put("vlrLimitDifCx", 0);
	}
	if ( !json.get( "vlrVendaDesc" ) || json.get( "vlrVendaDesc" ) === null || json.get( "vlrVendaDesc" ) === undefined ) {
		json.put("vlrVendaDesc", 0);
	}
	if ( !json.get( "vlrVendaTeleEntDesc" ) || json.get( "vlrVendaTeleEntDesc" ) === null || json.get( "vlrVendaTeleEntDesc" ) === undefined ) {
		json.put("vlrVendaTeleEntDesc", 0);
	}

	return json;
};
