/*
 Funções de validação de dados de Nota Fiscal de Entrada
 Data de Criação: 25/10/2016
 */

load('/basicos/validaCpfCnpj.js');
load('/rules/filial/validaDados.js');
load('/rules/produto/validaDados.js');
load('/rules/empresa/buscaParametros.js');
load('/model/erro/admErroPdvVdIntegracoes.js');

var CupomFiscal = function() {
   this.mapper = mapperFactory.createMapperMult(["PdvVd","AdmErroPdvVdIntegracoes"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

CupomFiscal.prototype.validaDadosCupomFiscal = function(json, gravarErro){
    if(json === null){
    	 throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }

    if(!gravarErro || gravarErro === undefined || gravarErro === null){
        gravarErro = false;
    }

        //################## Rotinas de Pré Validação de dados ########################
        //Valida se a nota já deu entrada no sistema e se ja foi importada anteriormente
        var jaImportada        = this.isCupomJaImportado(json);

        if(jaImportada){
            json.cdVd = jaImportada.get("cdVd")
            return json;
            //throw {code: 599, message: "Cupom Fiscal " + jaImportada.get("nrEcf") + " Com importação ja realizada na data " + jaImportada.get("dtCad")};
        }
        //################## Rotinas de Validação de dados do JSON ##################
        //######### Valida Dados da Filial #########
        var validaFilial = new ValidaFilial();
        var filial = validaFilial.validaDadosFilialByJSON(json);
        if(filial.error === true){
            throw filial;
        }
        if (json.dtVd < filial.dtIniSistema) {
          throw {code: 599, message: "Filial "+ json.cdFilial + ' - ' + filial.rzFilial + ' com data de inicio de sistema posterior a data de venda do cupom fiscal. Data de inicio do sistema: '
              + filial.dtIniSistema + ' Data da Venda :' + json.dtVd };
        }
        //var jsonValidado =  this.dadosDefault(json);
        //######### Valida Itens #########
        //this.validaItens(json);
        //this.mapper.commit();
        return json;

};

CupomFiscal.prototype.isCupomJaImportado = function(json){
   if(json === null){
      throw {code: 599, message: "Dados passados ao servidor inválido!"};
   }

   var mapper = mapperFactory.createMapperMult(["PdvVd","AdmErroPdvVdIntegracoes"]);

    var coo = 0;

    try{
       variaveis  = {};
       variaveis.cdEmp      = json.cdEmp;
       variaveis.cdFilial   = json.cdFilial;
       variaveis.cdCx       = json.cdCx;
       variaveis.nrEcf      = json.nrEcf;
       variaveis.dtVd       = json.dtVd;
       coo                  = mapper.selectOne("PdvVd.isValidPdvVd", variaveis);
    }finally{
        mapper.close();
    }
   return coo;
};

CupomFiscal.prototype.isJaImportadaAdmErro = function(json){
   if(json === null){
      throw {code: 599, message: "Dados passados ao servidor inválido!"};
   }

   variaveis         = {};
   variaveis.cdFilial   = json.get("cdFilial");
   variaveis.cdCx       = json.get("cdCx");
   variaveis.nrEcf      = json.get("nrEcf");
   variaveis.dtVd       = json.get("dtVd");
   variaveis.stsErro     = 1; // Importado com sucesso
   var erroDeImport = this.mapper.selectOne("AdmErroPdvVdIntegracoes.listarAdmErroPdvVdIntegracoes", variaveis);
   return erroDeImport;
};


CupomFiscal.prototype.validaItens = function(json){
    if (json.get("itens")){
      var itens = json.get("itens");
    }else{
      throw {code: 599, message: 'Cupom Fiscal ' + message.get("nrEcf") + ' Sem Itens'};
    }

    this.validaValoresItens(json);
};

CupomFiscal.prototype.validaValoresItens = function(json){
    var itens       = json.get("itens");
    var i           = 0;
    var vlrItem     = {};
    var diferenca   = {};

    //INICIA AS VARIAVEIS
    vlrItem.vlrTotIt             = 0 ;
    vlrItem.vlrDesc              = 0 ;
    vlrItem.vlrBaseIcms          = 0 ;
    vlrItem.vlrIcmsSubs          = 0 ;
    vlrItem.vlrBaseSubs          = 0 ;
    vlrItem.vlrIcmsDesonerado    = 0 ;
    vlrItem.vlrFreteIt           = 0 ;
    vlrItem.vlrIpi               = 0 ;
    vlrItem.vlrOutrasDespesas    = 0 ;
    diferenca.vlrTotProd         = 0 ;
    diferenca.vlrDesc            = 0 ;
    diferenca.vlrBaseIcms        = 0 ;
    diferenca.vlrIcmsSubs        = 0 ;
    diferenca.vlrBaseIcmsSubs    = 0 ;
    diferenca.vlrIcmsDesonerado  = 0 ;
    diferenca.vlrFrete           = 0 ;
    diferenca.vlrIpi             = 0 ;
    diferenca.vlrOutrasDespesas  = 0 ;
    diferenca.vlrNf              = 0 ;

    for (var j = 0; j < itens.size(); j++)
    {
        var item = itens.get(j);

        vlrItem.vlrTotIt            += item.get("vlrIt")   * item.get("qtIt");
        vlrItem.vlrDesc             += item.get("vlrDesc") * item.get("qtIt");
        vlrItem.vlrBaseIcms         += item.get("vlrBaseIcms");
        vlrItem.vlrIcmsSubs         += item.get("vlrIcmsSubs");
        vlrItem.vlrBaseSubs         += item.get("vlrBaseSubs");
        vlrItem.vlrIcmsDesonerado   += item.get("vlrIcmsDesonerado");
        vlrItem.vlrFreteIt          += item.get("vlrFreteIt");
        vlrItem.vlrIpi              += item.get("vlrIpi");
        vlrItem.vlrOutrasDespesas   += item.get("vlrOutrasDespesas");
    }

    diferenca.vlrTotProd        = json.get("vlrTotProd")         - (vlrItem.vlrTotIt);
    diferenca.vlrDesc           = json.get("vlrDesc")            - vlrItem.vlrDesc;
    diferenca.vlrBaseIcms       = json.get("vlrBaseIcms")        - vlrItem.vlrBaseIcms;
    diferenca.vlrIcmsSubs       = json.get("vlrIcmsSubs")        - vlrItem.vlrIcmsSubs;
    diferenca.vlrBaseIcmsSubs   = json.get("vlrBaseIcmsSubs")    - vlrItem.vlrBaseSubs;
    diferenca.vlrIcmsDesonerado = json.get("vlrIcmsDesonerado")  - vlrItem.vlrIcmsDesonerado;
    diferenca.vlrFrete          = json.get("vlrFrete")           - vlrItem.vlrFreteIt;
    diferenca.vlrIpi            = json.get("vlrIpi")             - vlrItem.vlrIpi;
    diferenca.vlrOutrasDespesas = json.get("vlrOutrasDespesas")  - vlrItem.vlrOutrasDespesas;
    var totalItens              = ( vlrItem.vlrOutrasDespesas + vlrItem.vlrFreteIt + vlrItem.vlrIcmsSubs + vlrItem.vlrIpi + vlrItem.vlrTotIt - vlrItem.vlrDesc);
    diferenca.vlrNf             = json.get("vlrNf") - totalItens;

   // var jsonConvert = new com.fasterxml.jackson.databind.ObjectMapper();
   /* java.lang.System.out.println('diferenca.vlrTotProd  ' + diferenca.vlrTotProd
                                +' diferenca.vlrDesc            ' + diferenca.vlrDesc
                                +' diferenca.vlrBaseIcms       ' + diferenca.vlrBaseIcms
                                +' diferenca.vlrIcmsSubs       ' + diferenca.vlrIcmsSubs
                                +' diferenca.vlrBaseIcmsSubs   ' + diferenca.vlrBaseIcmsSubs
                                +' diferenca.vlrIcmsDesonerado ' + diferenca.vlrIcmsDesonerado
                                +' diferenca.vlrFrete          ' + diferenca.vlrFrete
                                +' diferenca.vlrIpi            ' + diferenca.vlrIpi
                                +' diferenca.vlrOutrasDespesas ' + diferenca.vlrOutrasDespesas
                                +' diferenca.vlrNf               ' +  diferenca.vlrNf
                                +' vlrItem.vlrDesc ' + vlrItem.vlrDesc
                                +' vlrItem.vlrTotIt ' + vlrItem.vlrTotIt
    );
*/
    if (diferenca.vlrTotProd > 0 ){
        throw {code: 599, message: "Valor total dos Produtos divergente do valor total do(s) item(ns); "
        +" Valor total produto Cupom ...: " + json.get("vlrTotProd")
        +" Valor total produto itens ...: " + vlrItem.vlrTotIt.toFixed(2)
        +" Diferença ...................: " + diferenca.vlrTotProd.toFixed(2) };
    }
    if (diferenca.vlrBaseIcms > 0 ){
        throw {code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
        +" Valor total Base ICMS nota ...:  " + json.get("vlrBaseIcms")
        +" Valor total Base ICMS itens ..:  " + vlrItem.vlrBaseIcms
        +" Diferença ....................:  " + diferenca.vlrBaseIcms.toFixed(2) };
    }
    if (diferenca.vlrIcmsSubs > 0 ){
        throw {code: 599, message: "Valor total de ICMS Subst. divergente do valor total de ICMS Subst. do(s) item(ns); "
        +" Valor total Base ICMS Subst nota ...:  " + json.get("vlrIcmsSubs")
        +" Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrIcmsSubs
        +" Diferença ..........................:  " + diferenca.vlrIcmsSubs.toFixed(2) };
    }
    if (diferenca.vlrBaseIcmsSubs > 0 ){
        throw {code: 599, message: "Valor total de Base ICMS Subst. divergente do valor total de Base ICMS Subst. do(s) item(ns); "
        +" Valor total Base ICMS Subst nota ...:  " + json.get("vlrBaseIcmsSubs")
        +" Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrBaseSubs
        +" Diferença ..........................:  " + diferenca.vlrBaseIcmsSubs.toFixed(2)};
    }
    if (diferenca.vlrIcmsDesonerado > 0 ){
        throw {code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
        +" Valor total Base ICMS nota ...:  " + json.get("vlrIcmsDesonerado")
        +" Valor total Base ICMS itens ..:  " + vlrItem.vlrIcmsDesonerado
        +" Diferença ....................:  " + diferenca.vlrIcmsDesonerado.toFixed(2)};
    }
    if (diferenca.vlrFrete > 0 ){
        throw {code: 599, message: "Valor total de Frete divergente do valor total de Frete do(s) item(ns); "
        +" Valor total Frete nota ...:  " + json.get("vlrFrete")
        +" Valor total Frete itens ..:  " + vlrItem.vlrFreteIt
        +" Diferença ................:  " + diferenca.vlrFrete.toFixed(2) };
    }
    if (diferenca.vlrIpi > 0 ){
        throw {code: 599, message: "Valor total de IPI divergente do valor total de IPI do(s) item(ns); "
        +" Valor total IPI nota .....:   " + json.get("vlrIpi")
        +" Valor total IPI itens ....:   " + vlrItem.vlrIpi
        +" Diferença ................:  "  + diferenca.vlrIpi.toFixed(2) };
    }
    if (diferenca.vlrOutrasDespesas > 0 ){
        throw {code: 599, message: "Valor total de Outras despesasas divergente do valor total de Outras despesasas do(s) item(ns); "
        +" Valor total Outras despesasas nota ...:  " + json.get("vlrOutrasDespesas")
        +" Valor total Outras despesasas itens ..:  " + vlrItem.vlrOutrasDespesas
        +" Diferença ............................: "  + diferenca.vlrOutrasDespesas.toFixed(2) };
    }
    if (diferenca.vlrNf > 0 ){
        throw {code: 599, message: "Valor total da Nota divergente do somatório do(s) Produto(s); "
        +" Valor total Nota ...: " + json.get("vlrNf")
        +" Valor total Itens ..: " + totalItens
        +" Diferença ..........: " + diferenca.vlrNf.toFixed(2)};
    }

    delete itens;
    delete i;
    delete vlrItem;
    delete diferenca;

};



CupomFiscal.prototype.dadosDefault = function(json){
    if (json.get("itens")){
      var itens = json.get("itens");
    }else{
      throw {code: 599, message: 'Cupom Fiscal ' + message.get("nrEcf") + ' Sem Itens'};
    }

    if(!json.get("cancelTef") || json.get("cancelTef") === null || json.get("cancelTef") === undefined){
	json.put("cancelTef", 0);
    }
    if(!json.get("cdAdmCartao") || json.get("cdAdmCartao") === null || json.get("cdAdmCartao") === undefined){
        json.put("cdAdmCartao", 0);
    }
    if(!json.get("cdCli") || json.get("cdCli") === null || json.get("cdCli") === undefined){
        json.put("cdCli", 0);
    }
    if(!json.get("cdConv") || json.get("cdConv") === null || json.get("cdConv") === undefined){
        json.put("cdConv", 0);
    }
    if(!json.get("cdCx") || json.get("cdCx") === null || json.get("cdCx") === undefined){
        json.put("cdCx", 0);
    }
    if(!json.get("cdCxAdm") || json.get("cdCxAdm") === null || json.get("cdCxAdm") === undefined){
        json.put("cdCxAdm", 0);
    }
    if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
        json.put("cdEmp", 0);
    }
    if(!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined){
        json.put("cdFilial", 0);
    }
    if(!json.get("cdFilialVdTele") || json.get("cdFilialVdTele") === null || json.get("cdFilialVdTele") === undefined){
        json.put("cdFilialVdTele", 0);
    }
    if(!json.get("cdLancChq") || json.get("cdLancChq") === null || json.get("cdLancChq") === undefined){
        json.put("cdLancChq", 0);
    }
    if(!json.get("cdMov") || json.get("cdMov") === null || json.get("cdMov") === undefined){
        json.put("cdMov", 0);
    }
    if(!json.get("cdNf") || json.get("cdNf") === null || json.get("cdNf") === undefined){
        json.put("cdNf", 0);
    }
    if(!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined){
        json.put("cdUsu", 0);
    }
    if(!json.get("cdUsuCancel") || json.get("cdUsuCancel") === null || json.get("cdUsuCancel") === undefined){
        json.put("cdUsuCancel", 0);
    }
    if(!json.get("cdUsuOpe") || json.get("cdUsuOpe") === null || json.get("cdUsuOpe") === undefined){
        json.put("cdUsuOpe", 0);
    }
    if(!json.get("cdVd") || json.get("cdVd") === null || json.get("cdVd") === undefined){
        json.put("cdVd", 0);
    }
    if(!json.get("codModalidade") || json.get("codModalidade") === null || json.get("codModalidade") === undefined){
        json.put("codModalidade", " ");
    }
    if(!json.get("concCartao") || json.get("concCartao") === null || json.get("concCartao") === undefined){
        json.put("concCartao", 0);
    }
    if(!json.get("contCupomFisc") || json.get("contCupomFisc") === null || json.get("contCupomFisc") === undefined){
        json.put("contCupomFisc", 0);
    }
    if(!json.get("nmComprador") || json.get("nmComprador") === null || json.get("nmComprador") === undefined){
        json.put("nmComprador", " ");
    }
    if(!json.get("nmOperCel") || json.get("nmOperCel") === null || json.get("nmOperCel") === undefined){
        json.put("nmOperCel", " ");
    }
    if(!json.get("nrAutorizacao") || json.get("nrAutorizacao") === null || json.get("nrAutorizacao") === undefined){
        json.put("nrAutorizacao", " ");
    }
    if(!json.get("nrCartaoMarka4") || json.get("nrCartaoMarka4") === null || json.get("nrCartaoMarka4") === undefined){
        json.put("nrCartaoMarka4", " ");
    }
    if(!json.get("nrCelRecarga") || json.get("nrCelRecarga") === null || json.get("nrCelRecarga") === undefined){
        json.put("nrCelRecarga", " ");
    }
    if(!json.get("nrEcf") || json.get("nrEcf") === null || json.get("nrEcf") === undefined){
        json.put("nrEcf", 0);
    }
    if(!json.get("nrEcfAdm") || json.get("nrEcfAdm") === null || json.get("nrEcfAdm") === undefined){
        json.put("nrEcfAdm", 0);
    }
    if(!json.get("nrOperCel") || json.get("nrOperCel") === null || json.get("nrOperCel") === undefined){
        json.put("nrOperCel", 0);
    }
    if(!json.get("nrOrc") || json.get("nrOrc") === null || json.get("nrOrc") === undefined){
        json.put("nrOrc", 0);
    }
    if(!json.get("nrPedTelevd") || json.get("nrPedTelevd") === null || json.get("nrPedTelevd") === undefined){
        json.put("nrPedTelevd", 0);
    }
    if(!json.get("nsuConvExt") || json.get("nsuConvExt") === null || json.get("nsuConvExt") === undefined){
        json.put("nsuConvExt", 0);
    }
    if(!json.get("obs") || json.get("obs") === null || json.get("obs") === undefined){
        json.put("obs", " ");
    }
    if(!json.get("origOrc") || json.get("origOrc") === null || json.get("origOrc") === undefined){
        json.put("origOrc", 0);
    }
    if(!json.get("percIbpt") || json.get("percIbpt") === null || json.get("percIbpt") === undefined){
        json.put("percIbpt", 0);
    }
    if(!json.get("percRecConv") || json.get("percRecConv") === null || json.get("percRecConv") === undefined){
        json.put("percRecConv", 0);
    }
    if(!json.get("qtParcConv") || json.get("qtParcConv") === null || json.get("qtParcConv") === undefined){
        json.put("qtParcConv", 1);
    }
    if(!json.get("respImpDadosConsumidor") || json.get("respImpDadosConsumidor") === null || json.get("respImpDadosConsumidor") === undefined){
        json.put("respImpDadosConsumidor", 0);
    }
    if(!json.get("stCancPaf") || json.get("stCancPaf") === null || json.get("stCancPaf") === undefined){
        json.put("stCancPaf", 0);
    }
    if(!json.get("stImport") || json.get("stImport") === null || json.get("stImport") === undefined){
        json.put("stImport", 0);
    }
    if(!json.get("stVd") || json.get("stVd") === null || json.get("stVd") === undefined){
        json.put("stVd", 0);
    }
    if(!json.get("stsOrcPendTelevd") || json.get("stsOrcPendTelevd") === null || json.get("stsOrcPendTelevd") === undefined){
        json.put("stsOrcPendTelevd", 0);
    }
    if(!json.get("tipo") || json.get("tipo") === null || json.get("tipo") === undefined){
        json.put("tipo", 0);
    }
    if(!json.get("tpPercRecConv") || json.get("tpPercRecConv") === null || json.get("tpPercRecConv") === undefined){
        json.put("tpPercRecConv", 0);
    }
    if(!json.get("valorIbpt") || json.get("valorIbpt") === null || json.get("valorIbpt") === undefined){
        json.put("valorIbpt", 0);
    }
    if(!json.get("vdTrocaFidel") || json.get("vdTrocaFidel") === null || json.get("vdTrocaFidel") === undefined){
        json.put("vdTrocaFidel", 0);
    }
    if(!json.get("vincChq") || json.get("vincChq") === null || json.get("vincChq") === undefined){
        json.put("vincChq", 0);
    }
    if(!json.get("vlChqsAPrz") || json.get("vlChqsAPrz") === null || json.get("vlChqsAPrz") === undefined){
        json.put("vlChqsAPrz", 0);
    }
    if(!json.get("vlChqsAVista") || json.get("vlChqsAVista") === null || json.get("vlChqsAVista") === undefined){
        json.put("vlChqsAVista", 0);
    }
    if(!json.get("vlrCartao") || json.get("vlrCartao") === null || json.get("vlrCartao") === undefined){
        json.put("vlrCartao", 0);
    }
    if(!json.get("vlrChqs") || json.get("vlrChqs") === null || json.get("vlrChqs") === undefined){
        json.put("vlrChqs", 0);
    }
    if(!json.get("vlrConv") || json.get("vlrConv") === null || json.get("vlrConv") === undefined){
        json.put("vlrConv", 0);
    }
    if(!json.get("vlrConvPbm") || json.get("vlrConvPbm") === null || json.get("vlrConvPbm") === undefined){
        json.put("vlrConvPbm", 0);
    }
    if(!json.get("vlrCrediario") || json.get("vlrCrediario") === null || json.get("vlrCrediario") === undefined){
        json.put("vlrCrediario", 0);
    }
    if(!json.get("vlrDesc") || json.get("vlrDesc") === null || json.get("vlrDesc") === undefined){
        json.put("vlrDesc", 0);
    }
    if(!json.get("vlrDescItens") || json.get("vlrDescItens") === null || json.get("vlrDescItens") === undefined){
        json.put("vlrDescItens", 0);
    }
    if(!json.get("vlrDinh") || json.get("vlrDinh") === null || json.get("vlrDinh") === undefined){
        json.put("vlrDinh", 0);
    }
    if(!json.get("vlrDup") || json.get("vlrDup") === null || json.get("vlrDup") === undefined){
        json.put("vlrDup", 0);
    }
    if(!json.get("vlrLiqVd") || json.get("vlrLiqVd") === null || json.get("vlrLiqVd") === undefined){
        json.put("vlrLiqVd", 0);
    }
    if(!json.get("vlrNcc") || json.get("vlrNcc") === null || json.get("vlrNcc") === undefined){
        json.put("vlrNcc", 0);
    }
    if(!json.get("vlrRecargaCel") || json.get("vlrRecargaCel") === null || json.get("vlrRecargaCel") === undefined){
        json.put("vlrRecargaCel", 0);
    }
    if(!json.get("vlrSaqueCartao") || json.get("vlrSaqueCartao") === null || json.get("vlrSaqueCartao") === undefined){
        json.put("vlrSaqueCartao", 0);
    }
    if(!json.get("vlrTickets") || json.get("vlrTickets") === null || json.get("vlrTickets") === undefined){
        json.put("vlrTickets", 0);
    }
    if(!json.get("vlrTotProd") || json.get("vlrTotProd") === null || json.get("vlrTotProd") === undefined){
        json.put("vlrTotProd", 0);
    }
    if(!json.get("vlrTrocoChq") || json.get("vlrTrocoChq") === null || json.get("vlrTrocoChq") === undefined){
        json.put("vlrTrocoChq", 0);
    }
    if(!json.get("vlrVd") || json.get("vlrVd") === null || json.get("vlrVd") === undefined){
        json.put("vlrVd", 0);
    }
    if(!json.get("vsConsolidador") || json.get("vsConsolidador") === null || json.get("vsConsolidador") === undefined){
        json.put("vsConsolidador", " ");
    }
    if(!json.get("vsPdv") || json.get("vsPdv") === null || json.get("vsPdv") === undefined){
        json.put("vsPdv", " ");
    }

    return json;
}


CupomFiscal.prototype.dadosDefaultItem = function(json){
    if (json.get("itens")){
      var itens = json.get("itens");
    }else{
      throw {code: 599, message: 'Cupom Fiscal ' + message.get("nrEcf") + ' Sem Itens'};
    }

    if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
        json.put("cdEmp", 0);
    }
    if(!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined){
        json.put("cdFilial", 0);
    }
    if(!json.get("cdIt") || json.get("cdIt") === null || json.get("cdIt") === undefined){
        json.put("cdIt", 0);
    }
    if(!json.get("cdNtOp") || json.get("cdNtOp") === null || json.get("cdNtOp") === undefined){
        json.put("cdNtOp", 0);
    }
    if(!json.get("cdProd") || json.get("cdProd") === null || json.get("cdProd") === undefined){
        json.put("cdProd", 0);
    }
    if(!json.get("cdTribFc") || json.get("cdTribFc") === null || json.get("cdTribFc") === undefined){
        json.put("cdTribFc", " ");
    }
    if(!json.get("cdUsuCancel") || json.get("cdUsuCancel") === null || json.get("cdUsuCancel") === undefined){
        json.put("cdUsuCancel", 0);
    }
    if(!json.get("cdVd") || json.get("cdVd") === null || json.get("cdVd") === undefined){
        json.put("cdVd", 0);
    }
    if(!json.get("cdVend") || json.get("cdVend") === null || json.get("cdVend") === undefined){
        json.put("cdVend", 0);
    }
    if(!json.get("cdVendVerba") || json.get("cdVendVerba") === null || json.get("cdVendVerba") === undefined){
        json.put("cdVendVerba", 0);
    }
    if(!json.get("coefPmz") || json.get("coefPmz") === null || json.get("coefPmz") === undefined){
        json.put("coefPmz", 0);
    }
    if(!json.get("cstCofins") || json.get("cstCofins") === null || json.get("cstCofins") === undefined){
        json.put("cstCofins", 0);
    }
    if(!json.get("cstPis") || json.get("cstPis") === null || json.get("cstPis") === undefined){
        json.put("cstPis", 0);
    }
    if(!json.get("dependente") || json.get("dependente") === null || json.get("dependente") === undefined){
        json.put("dependente", 0);
    }
    if(!json.get("descFixadoCad") || json.get("descFixadoCad") === null || json.get("descFixadoCad") === undefined){
        json.put("descFixadoCad", 0);
    }
    if(!json.get("fecopRecalculado") || json.get("fecopRecalculado") === null || json.get("fecopRecalculado") === undefined){
        json.put("fecopRecalculado", 0);
    }
    if(!json.get("flagExcecaoPisCofins") || json.get("flagExcecaoPisCofins") === null || json.get("flagExcecaoPisCofins") === undefined){
        json.put("flagExcecaoPisCofins", 0);
    }
    if(!json.get("flagProdCestaBasica") || json.get("flagProdCestaBasica") === null || json.get("flagProdCestaBasica") === undefined){
        json.put("flagProdCestaBasica", 0);
    }
    if(!json.get("liberaVdConv") || json.get("liberaVdConv") === null || json.get("liberaVdConv") === undefined){
        json.put("liberaVdConv", 0);
    }
    if(!json.get("listaProd") || json.get("listaProd") === null || json.get("listaProd") === undefined){
        json.put("listaProd", 0);
    }
    if(!json.get("percAliqCofins") || json.get("percAliqCofins") === null || json.get("percAliqCofins") === undefined){
        json.put("percAliqCofins", 0);
    }
    if(!json.get("percAliqPis") || json.get("percAliqPis") === null || json.get("percAliqPis") === undefined){
        json.put("percAliqPis", 0);
    }
    if(!json.get("percAplic") || json.get("percAplic") === null || json.get("percAplic") === undefined){
        json.put("percAplic", 0);
    }
    if(!json.get("percComi") || json.get("percComi") === null || json.get("percComi") === undefined){
        json.put("percComi", 0);
    }
    if(!json.get("percComiCtr") || json.get("percComiCtr") === null || json.get("percComiCtr") === undefined){
        json.put("percComiCtr", 0);
    }
    if(!json.get("percComis") || json.get("percComis") === null || json.get("percComis") === undefined){
        json.put("percComis", 0);
    }
    if(!json.get("percDescCtr") || json.get("percDescCtr") === null || json.get("percDescCtr") === undefined){
        json.put("percDescCtr", 0);
    }
    if(!json.get("percDescFidel") || json.get("percDescFidel") === null || json.get("percDescFidel") === undefined){
        json.put("percDescFidel", 0);
    }
    if(!json.get("percDescFidelMax") || json.get("percDescFidelMax") === null || json.get("percDescFidelMax") === undefined){
        json.put("percDescFidelMax", 0);
    }
    if(!json.get("percDescVerba") || json.get("percDescVerba") === null || json.get("percDescVerba") === undefined){
        json.put("percDescVerba", 0);
    }
    if(!json.get("percFecop") || json.get("percFecop") === null || json.get("percFecop") === undefined){
        json.put("percFecop", 0);
    }
    if(!json.get("percIbpt") || json.get("percIbpt") === null || json.get("percIbpt") === undefined){
        json.put("percIbpt", 0);
    }
    if(!json.get("percMetaAtend") || json.get("percMetaAtend") === null || json.get("percMetaAtend") === undefined){
        json.put("percMetaAtend", 0);
    }
    if(!json.get("pisCofins") || json.get("pisCofins") === null || json.get("pisCofins") === undefined){
        json.put("pisCofins", 0);
    }
    if(!json.get("pisCofinsRecalculado") || json.get("pisCofinsRecalculado") === null || json.get("pisCofinsRecalculado") === undefined){
        json.put("pisCofinsRecalculado", 0);
    }
    if(!json.get("qtEstAnt") || json.get("qtEstAnt") === null || json.get("qtEstAnt") === undefined){
        json.put("qtEstAnt", 0);
    }
    if(!json.get("qtIt") || json.get("qtIt") === null || json.get("qtIt") === undefined){
        json.put("qtIt", 0);
    }
    if(!json.get("stIt") || json.get("stIt") === null || json.get("stIt") === undefined){
        json.put("stIt", 0);
    }
    if(!json.get("tipoDesconto") || json.get("tipoDesconto") === null || json.get("tipoDesconto") === undefined){
        json.put("tipoDesconto", 0);
    }
    if(!json.get("tipoTributacaoPisCofins") || json.get("tipoTributacaoPisCofins") === null || json.get("tipoTributacaoPisCofins") === undefined){
        json.put("tipoTributacaoPisCofins", 0);
    }
    if(!json.get("totIt") || json.get("totIt") === null || json.get("totIt") === undefined){
        json.put("totIt", 0);
    }
    if(!json.get("tpProd") || json.get("tpProd") === null || json.get("tpProd") === undefined){
        json.put("tpProd", 0);
    }
    if(!json.get("txDesc") || json.get("txDesc") === null || json.get("txDesc") === undefined){
        json.put("txDesc", 0);
    }
    if(!json.get("valorIbpt") || json.get("valorIbpt") === null || json.get("valorIbpt") === undefined){
        json.put("valorIbpt", 0);
    }
    if(!json.get("vdOperador") || json.get("vdOperador") === null || json.get("vdOperador") === undefined){
        json.put("vdOperador", 0);
    }
    if(!json.get("vlrBaseCofins") || json.get("vlrBaseCofins") === null || json.get("vlrBaseCofins") === undefined){
        json.put("vlrBaseCofins", 0);
    }
    if(!json.get("vlrBasePis") || json.get("vlrBasePis") === null || json.get("vlrBasePis") === undefined){
        json.put("vlrBasePis", 0);
    }
    if(!json.get("vlrCofins") || json.get("vlrCofins") === null || json.get("vlrCofins") === undefined){
        json.put("vlrCofins", 0);
    }
    if(!json.get("vlrComissaoFabric") || json.get("vlrComissaoFabric") === null || json.get("vlrComissaoFabric") === undefined){
        json.put("vlrComissaoFabric", 0);
    }
    if(!json.get("vlrCusto") || json.get("vlrCusto") === null || json.get("vlrCusto") === undefined){
        json.put("vlrCusto", 0);
    }
    if(!json.get("vlrCustoGer") || json.get("vlrCustoGer") === null || json.get("vlrCustoGer") === undefined){
        json.put("vlrCustoGer", 0);
    }
    if(!json.get("vlrCustoMedio") || json.get("vlrCustoMedio") === null || json.get("vlrCustoMedio") === undefined){
        json.put("vlrCustoMedio", 0);
    }
    if(!json.get("vlrDescCad") || json.get("vlrDescCad") === null || json.get("vlrDescCad") === undefined){
        json.put("vlrDescCad", 0);
    }
    if(!json.get("vlrDescTotRat") || json.get("vlrDescTotRat") === null || json.get("vlrDescTotRat") === undefined){
        json.put("vlrDescTotRat", 0);
    }
    if(!json.get("vlrDescVerba") || json.get("vlrDescVerba") === null || json.get("vlrDescVerba") === undefined){
        json.put("vlrDescVerba", 0);
    }
    if(!json.get("vlrIt") || json.get("vlrIt") === null || json.get("vlrIt") === undefined){
        json.put("vlrIt", 0);
    }
    if(!json.get("vlrOferta") || json.get("vlrOferta") === null || json.get("vlrOferta") === undefined){
        json.put("vlrOferta", 0);
    }
    if(!json.get("vlrPis") || json.get("vlrPis") === null || json.get("vlrPis") === undefined){
        json.put("vlrPis", 0);
    }
    if(!json.get("vlrPmc") || json.get("vlrPmc") === null || json.get("vlrPmc") === undefined){
        json.put("vlrPmc", 0);
    }
    if(!json.get("vlrPmz") || json.get("vlrPmz") === null || json.get("vlrPmz") === undefined){
        json.put("vlrPmz", 0);
    }
    if(!json.get("vlrRecomposicaoMargem") || json.get("vlrRecomposicaoMargem") === null || json.get("vlrRecomposicaoMargem") === undefined){
        json.put("vlrRecomposicaoMargem", 0);
    }
    return json;
}
