var PedidoEncomenda = function () {
    this.mapper = mapperFactory.createMapperMult(["EstProdReqTransfPedido", "EstProdReqTransfSld", "EstProdTransfIt", "EstProdTransf", "EstProdPreco", "EstProd", "VPrcFilial"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

PedidoEncomenda.prototype.gerarSolicitacaoDeDemanda = function (json) {
     return this.mapper.selectList("EstProdReqTransfSld.gerarSolicitacaoDeDemanda", {'cdUsu': json.get('cdUsu'), 'cdEmp': json.get('cdEmp')});
};

PedidoEncomenda.prototype.abaterSolictacoesAtendidas = function (json) {
     this.mapper.update("EstProdReqTransfSld.abaterSolictacoesAtendidas", {'cdUsu': json.get('cdUsu'), 'cdEmp': json.get('cdEmp')});
};

PedidoEncomenda.prototype.removeItensNaoPassadosPorRessuprimento = function (json) {
     this.mapper.update("EstProdReqTransfSld.removeItensNaoPassadosPorRessuprimento", {'cdUsu': json.get('cdUsu'), 'cdEmp': json.get('cdEmp')});
};

PedidoEncomenda.prototype.gerarRessuprimentoPedidoEncomenda = function (json) {

    try {

        let dataAtual = new Date();
        let result = {
            'ressuprimentos': [],
            'demandas': this.gerarSolicitacaoDeDemanda(json)
        };

        this.abaterSolictacoesAtendidas(json);
        this.removeItensNaoPassadosPorRessuprimento(json);

        let listaDadosAgrupadosPorFilial = this.mapper.selectList("EstProdReqTransfSld.selectControlePontoEncomendaPorFilial", {'cdUsu': json.get('cdUsu')});

        if(listaDadosAgrupadosPorFilial.size() == 0 && result.demandas.size() == 0){
            throw {
                'code': 599,
                'message': 'Não foi encontrado nenhum valor definido para geração de ressuprimento ou demanda'
            };
        }

        let cdFilialDeposito = this.mapper.selectList("VPrcFilial.listarVPrcFilialRelacaoDeposito", {});

        for (let i = 0; i < listaDadosAgrupadosPorFilial.size(); i++) {
            let cdCtrCabecalho = this.mapper.selectOne("EstProdTransf.maxEstProdTransf", {});

            this.mapper.insert("EstProdTransf.incluirEstProdTransf", {
                'cdEmp': 1,
                'cdFilial': cdFilialDeposito.get(0).get('cdDeposito'),
                'cdCtr': cdCtrCabecalho.get('cdCtr'),
                'tpTransf': 1,
                'cdFilOrig': cdFilialDeposito.get(0).get('cdDeposito'),
                'cdFilDest': listaDadosAgrupadosPorFilial.get(i).get('cdFilial'),
                'dtTransf': json.get('dtTransf'),
                'dtEntr': json.get('dtTransf'),
                'stsTransf': 0,
                'cdUsu': json.get('cdUsu'),
                'flagCaixaFechada': 0,
                'flagCheckoutIniciado': 0,
                'flagQtdeCheckout': 0,
                'ressupDivido': 0,
                'observacao': 'ENCOMENDA',
                'ajustado': 1
            });

            let listaDadosAgrupadosPorProduto = this.mapper.selectList("EstProdReqTransfSld.selectControlePontoEncomenda", {
                'cdFilial': listaDadosAgrupadosPorFilial.get(i).get('cdFilial'),
                'cdUsu': json.get('cdUsu')
            });

            result.ressuprimentos.push({
                'cdCtrCabecalho': cdCtrCabecalho.get('cdCtr'),
                'cdDeposito': cdFilialDeposito.get(0).get('cdDeposito'),
                'nmFilDeposito': cdFilialDeposito.get(0).get('nmFant'),
                'dtCad': dataAtual.getTime(),
                'cdFilial': listaDadosAgrupadosPorFilial.get(i).get('cdFilial'),
                'nmFilial': listaDadosAgrupadosPorFilial.get(i).get('nmFilial'),
                'cdPedWms': 0,
                'dsStsTransf': 'NAO FATURADO',
                'dsTpTransf': 'LIBERACAO DE SOLICITACAO'
            });

            for (let j = 0; j < listaDadosAgrupadosPorProduto.size(); j++) {
                if (listaDadosAgrupadosPorProduto.get(j).get('cdFilial') == listaDadosAgrupadosPorFilial.get(i).get('cdFilial')) {
                    let vlrCusto = this.mapper.selectOne("EstProdPreco.listarEstProdPreco", {
                        'cdFilial': listaDadosAgrupadosPorFilial.get(i).get('cdFilial'),
                        'cdProd': listaDadosAgrupadosPorProduto.get(j).get('cdProd')
                    });

                    let qtUniRessuprimento = this.mapper.selectOne("EstProd.listarEstProd", {
                        'cdProd': listaDadosAgrupadosPorProduto.get(j).get('cdProd')
                    });

                    this.mapper.insert("EstProdTransfIt.incluirEstProdTransfIt", {
                        'cdEmp': 1,
                        'cdFilial': cdFilialDeposito.get(0).get('cdDeposito'),
                        'cdCtr': cdCtrCabecalho.get('cdCtr'),
                        'cdProd': listaDadosAgrupadosPorProduto.get(j).get('cdProd'),
                        'qtSol': listaDadosAgrupadosPorProduto.get(j).get('qtAtend'),
                        'qtAt': 0,
                        'vlrCusto': vlrCusto.get('vlrCusto'),
                        'qtEstRes': 0,
                        'qtMediaf': 0,
                        'qtEmax': 0,
                        'qtEseg': 0,
                        'flagRateio': 0,
                        'qtEstDepoRes': 0,
                        'percRateio': 0,
                        'percDesc': 0,
                        'qtEst': 0,
                        'qtPendEnt': 0,
                        'emaxRes': 0,
                        'esegRes': 0,
                        'vlrCustoMd': 0,
                        'vlrCustoAcerto': 0,
                        'qtUniRessuprimento': qtUniRessuprimento.get('qtUniRessuprimento'),
                        'qtNecessidade': 0,
                        'tpPreco': 0,
                        'aliqIcmsEntrada': 0,
                        'qtSolEncomenda': listaDadosAgrupadosPorProduto.get(j).get('qtProd'),
                        'flagLimparSaldo': listaDadosAgrupadosPorProduto.get(j).get('flagZerarRessuprimento')
                    });
                }
            }

        }

        this.mapper.insert("EstProdReqTransfSld.excluirControlePontoEncomenda", {
            'cdEmp': 1,
            'cdUsu': json.get('cdUsu')
        });

        this.mapper.commit();
        return result;

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }

};