var AtualizadorPrecoVenda = function () {
    this.mapper =  mapperFactory.createMapperMult(['GlbScheduleArquivos', 'GlbScheduleJob', 'EstProdPrecoAlt', 'EstProdPrecoAltCpl', 'EstProdPrecoAltPrcFilial', 'EstProdPrecoAltUnico']);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
    this.job = null;
    this.dados = null;
};


AtualizadorPrecoVenda.prototype.processarArquivo = function () {
    let param = new java.util.HashMap();
    param.put('cdEmp', this.dados.get('arquivo').get('cdEmp'));
    param.put('tpAltPreco', 0);
    param.put('zeroOferta', 0);
    param.put('cdUsu', this.dados.get('arquivo').get('cdUsu'));
    param.put('dsAltPreco', this.dados.get('arquivo').get('descricao'));
    param.put('dtAgendada', this.dados.get('arquivo').get('dtAgendada'));
    param.put('origemPreco', 1);
    param.put('aplicarPrecoFamilia', this.dados.get('arquivo').get('aplicarPrecoFamilia'));
    param.put('precoAgendado', this.dados.get('arquivo').get('precoAgendado'));
    param.put('dtFimAgenda', this.dados.get('arquivo').get('dtFimAgenda'));

    param.put('listaDePreco', new java.util.ArrayList());
    param.put('filiais', this.dados.get('arquivo').get('filiais'));

    let numMarkers = 0;

    this.mapper.insert('EstProdPrecoAlt.incluirEstProdPrecoAlt', param);

    for(let i = 0; i < this.dados.get('arquivo').get('listaDePreco').size(); i++){
        let item = this.dados.get('arquivo').get('listaDePreco').get(i);
        if((numMarkers + 4) > 2000){

            this.mapper.insert('EstProdPrecoAltCpl.incluirEstProdPrecoAltCplEmLote', param);
            param.get('listaDePreco').clear();
            numMarkers = 0;
            i --;
        }else{
            param.get('listaDePreco').add(item);
            numMarkers = numMarkers + 4;
        }
    }

    if(param.get('listaDePreco').size() > 0)
        this.mapper.insert('EstProdPrecoAltCpl.incluirEstProdPrecoAltCplEmLote', param);

    if(param.get('filiais').size() > 0)
        this.mapper.insert('EstProdPrecoAltPrcFilial.incluirEstProdPrecoAltPrcFilialEmLote', {'cdEmp': param.get('cdEmp'), 'cdAltPreco': param.get('cdAltPreco'), 'filiais': param.get('filiais')});

    this.mapper.update('EstProdPrecoAlt.pAnalisaMargemEstProdPreco',{'cdUsu': this.dados.get('arquivo').get('cdUsu')});
    this.mapper.update('GlbScheduleJob.alterarGlbScheduleJob',{'cdCtr': this.dados.get('cdCtr'), 'sts':1});
};

/**
*   @description
*   Assume que a lista listaDePreco já se encontra ordenada por cdProd e vlrTabela
*/
AtualizadorPrecoVenda.prototype.parseDados = function(){

    let _listaDePreco = new java.util.ArrayList();
    this.dados.put('arquivo', mapperFactory.mapFromStringJson(this.dados.get('arquivo')));

    for(let i = 0; i<this.dados.get('arquivo').get('listaDePreco').size(); i++){

         let item = this.dados.get('arquivo').get('listaDePreco').get(i);
         if (_listaDePreco.size() == 0) {

                let _item = new java.util.HashMap();
                let _filiais = new java.util.ArrayList();
                _filiais.add(item.get('cdFilial'));

                _item.put('vlrTabela', item.get('vlrTabela'));
                _item.put('filiais', _filiais);
                _item.put('cdProd', item.get('cdProd'));

                _listaDePreco.add(_item);

         } else{

                  if (_listaDePreco.get(_listaDePreco.size() - 1).get('cdProd') == item.get('cdProd') && _listaDePreco.get(_listaDePreco.size() - 1).get('vlrTabela') == item.get('vlrTabela')) {
                        let _filiais = _listaDePreco.get(_listaDePreco.size() - 1).get('filiais');
                        if(!_filiais.contains(item.get('cdFilial')))
                            _listaDePreco.get(_listaDePreco.size() - 1).get('filiais').add(item.get('cdFilial'));

                  }else{
                        let _item = new java.util.HashMap();
                        let _filiais = new java.util.ArrayList();
                        _filiais.add(item.get('cdFilial'));

                         _item.put('vlrTabela', item.get('vlrTabela'));
                        _item.put('filiais', _filiais);
                        _item.put('cdProd', item.get('cdProd'));

                        _listaDePreco.add(_item);
                  }
         }
    }

     this.dados.get('arquivo').put('listaDePreco', _listaDePreco);
};


AtualizadorPrecoVenda.prototype.processar = function () {

    this.job = this.mapper.selectOne("GlbScheduleJob.listarCdCtrProcessar", {'nmSchedule': 'IMPORTACAO_PRECO'});

    if(this.job != null && this.job.get('cdCtrJob') != null){
        this.mapper.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 2, 'cdCtr': this.job.get('cdCtrJob')});
        this.dados = this.mapper.selectOne('GlbScheduleJob.listarArquivosPrecoVenda', {'cdCtr': this.job.get('cdCtrJob')});

        if(this.dados != null){
            this.parseDados();
            this.processarArquivo();
        }
    }
};