var AtualizadorAbcPharma = function () {
    this.mapper =  mapperFactory.createMapperMult(['ArqAbcPharmaTmp', 'EstProdPrecoTblHist', 'EstProdPrecoTblHistCpl', 'EstProdCdBarra', 'PrcEmpConfig']);

    let configuracoes = this.mapper.selectList('PrcEmpConfig.listarPrcEmpConfigPelasChaves', {'cdEmp': 1, 'chaves': ['USUARIO_WEBSERVICE_ABC_FARMA', 'SENHA_WEBSERVICE_ABC_FARMA', 'CNPJ_SOFTWARE_HOUSE_WEBSERVICE_ABC_FARMA']});

    this.param = mapperFactory.createMap();
    this.param.put("cnpj_sh", configuracoes.get(0).get('valor'));
    this.param.put("senha", configuracoes.get(1).get('valor'));
    this.param.put("cnpj_cpf", configuracoes.get(2).get('valor'));

    this.url = "https://webserviceabcfarma.org.br/webservice/";
    this.dados = [];
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};


AtualizadorAbcPharma.prototype.getProdutos = function (nrPagina) {
    java.lang.System.out.println('Download page abcfarma: '+nrPagina);
    this.param.put("pagina", ''+nrPagina);
    let map = mapperFactory.mapFromStringJson(http.post(this.url, this.param));
    this.dados = this.dados.concat(JSON.parse(this.jsonConvert.toJson(map.get('data'))));

    nrPagina ++;
    if(nrPagina <= map.get('total_paginas'))
        this.getProdutos(nrPagina);
};


AtualizadorAbcPharma.prototype.salvar = function(){
    for(let i=0; i<(this.dados.length-1); i++){
        for(let j=(i+1); j<this.dados.length; j++){
           if(this.dados[i].EAN == this.dados[j].EAN){
                this.dados.splice(j, 1);
                break;
           }
        }
    }
    this.mapper.insert('ArqAbcPharmaTmp.incluirArquivo', {'json': this.jsonConvert.toJson(this.dados)});
};


AtualizadorAbcPharma.prototype.getPreco = function(produto, aliquota, tblHist, param){
    let _aliquota = (aliquota+'').replace('.','_').replace('_0', '');
    let _pf = 'PF_'+_aliquota;
    let _pmc = 'PMC_'+_aliquota;
    if(tblHist.get('zonaFranca') == 1){
        _pf = _pf+'_ALC';
        _pmc = _pmc+'_ALC';
    }

    if(produto[_pf] === undefined || produto[_pmc] === undefined)
        return false;

    param.push({
        'cdEmp': tblHist.get('cdEmp'),
        'cdCtr': tblHist.get('cdCtr'),
        'ean': produto.EAN,
        'zonaFranca': tblHist.get('zonaFranca'),
        'percIcms': aliquota,
        'cdTiss': 0,
        'vlrForn': produto[_pf],
        'vlrVd': produto[_pmc]
    });

    return true;
};

AtualizadorAbcPharma.prototype.processarItens = function(produtos, tblHist, inicio, fim){
    try{
        let param = [];
        for(let i = inicio; i<fim; i++){

            if(this.getPreco(produtos[i], tblHist.get('percIcms'), tblHist, param)){
                if(tblHist.get('flagExcecao') == 1 && tblHist.get('percExcecao') != tblHist.get('percIcms')) 
                    this.getPreco(produtos[i], tblHist.get('percExcecao'), tblHist, param);
            }
        }

        this.mapper.insert('EstProdPrecoTblHistCpl.incluirItensImportadosAbcFarma', {'produtos':param});

    }catch(err){
        java.lang.System.out.println(err);
    }
};


AtualizadorAbcPharma.prototype.gravarItensImportados = function(tblHist){
    let produtos = JSON.parse(this.mapper.selectOne('ArqAbcPharmaTmp.getJson', {}).get('json'));
    let tamanho = 125;

    if(!produtos || produtos.length == 0)
        return ;

    if(produtos.length <= tamanho){
        this.processarItens(produtos, tblHist, 0, produtos.length);
    }else{
        let tamanhoPull = Math.ceil(produtos.length/tamanho);
        let service = java.util.concurrent.Executors.newFixedThreadPool(tamanhoPull);
        let futureList = new java.util.ArrayList();
        let diff = produtos.length - (tamanho*(tamanhoPull-1)) ;

        for (let i=0; i<tamanhoPull; i++){
            if(i == (tamanhoPull-1)){
                let param = {
                    'i': i,
                    'produtos': produtos,
                    'tblHist': tblHist,
                    'tamanho': tamanho,
                    'diff': diff,
                    'obj': this,
                    'call': function(){
                        //java.lang.System.out.println("==> I: "+this.i+" ==> inicio: "+ (this.i*this.tamanho)+ " ==> fim: "+this.produtos.length);
                        this.obj.processarItens(this.produtos, this.tblHist, (this.i*this.tamanho), this.produtos.length);
                    }
                };

                let callable = new java.util.concurrent.Callable(param);
                futureList.add(callable);
            } else{

                let param = {
                    'i': i,
                    'produtos': produtos,
                    'tblHist': tblHist,
                    'tamanho': tamanho,
                    'obj': this,
                    'call': function(){
                        //java.lang.System.out.println("==> I: "+this.i+" ==> inicio: "+ (this.i*this.tamanho)+ " ==> fim: "+(this.tamanho*this.i+this.tamanho));
                        this.obj.processarItens(this.produtos, this.tblHist, (this.i*this.tamanho), (this.tamanho*this.i+this.tamanho));
                    }
                };

                let callable = new java.util.concurrent.Callable(param);
                futureList.add(callable);
            }
        }
        service.invokeAll(futureList);
        service.shutdown();
    }
};


AtualizadorAbcPharma.prototype.processar = function(tblHistAbcFarma){
    if(tblHistAbcFarma == null)
        return;

    this.mapper.update('EstProdPrecoTblHist.alterarEstProdPrecoTblHist', {'flagProcessado': 3, 'cdEmp': tblHistAbcFarma.get('cdEmp'), 'cdCtr':tblHistAbcFarma.get('cdCtr')});
    this.gravarItensImportados(tblHistAbcFarma);

};