load( "/rules/produto/cdBarra/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var CodigoBarra = function( ) {
	this.mapper        = mapperFactory.createMapperMult([ "EstProdCdBarra", "EstProd" ]);
	this.validaCdBarra = new ValidaCdBarra( );
	this.gravaErro     = new AdmErroIntegracoes( );
	this.jsonConvert   = new com.google.gson.GsonBuilder( ).create( );
	this.i             = 0;
};

/**
 * Metodo faz controle das inserções de familia a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
CodigoBarra.prototype.insereCodigoBarra = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item         = obj.get( this.i );
      var itemValidado = this.validaCdBarra.validaDadosParaCadastro(item);
      this.mapper.insert("EstProdCdBarra.inserirEstProdCdBarra", itemValidado);
      this.gravaSucesso( itemValidado );
		}

    this.mapper.commit( );
    return obj;
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		if ( err.code ) {
			throw JSON.stringify( err );
		}
		throw "{erro:true,  message:'" + escape( err ) + "'}";
	}
};

CodigoBarra.prototype.gravaSucesso = function( json ) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id             = parseInt(json.get( "cdProd" ));
	msgErro.tabela         = "EST_PROD_CD_BARRA";
	msgErro.jsonEnviado    = this.jsonConvert.toJson( json );
	msgErro.stsErro        = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao  = 0;
	msgErro.laudo          = 'Registro ' + json.get( "cdProd" ) + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro( metodo, msgErro );
};

CodigoBarra.prototype.gravaErro = function( json ) {
	java.lang.System.out.println( 'itemValidado ' + itemValidado );
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get( "cdConv" ) || 0;
	msgErro.tabela = json.get( "tabela" );
	msgErro.jsonEnviado = this.jsonConvert.toJson( json );
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson( err );
	this.gravaErro.gerenciaErro( metodo, msgErro );
};
