/**
 * Created by maurodouglas on 07/11/16.
 */

var PreFatura = function() {
    this.mapper = mapperFactory.createMapperMult(["EstPedVd", "EstPedVdIt"]);
};

PreFatura.prototype.gerenciarPreFatura = function(metodo, json){
    if(json === null || json.size() === 0){
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    try{
        switch(metodo) {
            case 'POST':
                this.mapper.insert("EstPedVd.incluirEstPedVd", json);
                this.mapper.commit();
                break;
            case 'PUT':
                this.mapper.update("EstPedVd.alterarEstPedVd", json);
                this.mapper.commit();
                break;
            case 'DELETE':
                this.mapper.update("EstPedVd.alterarEstPedVd", json);
                this.mapper.commit();
                break;
        }

    }catch(err){
        this.mapper.rollback();
        throw err;
    }

};

PreFatura.prototype.gerenciarPreFaturaItens = function(metodo, json){
    if(json === null || json.size() === 0){
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    try{
        switch(metodo) {
            case 'POST':
                this.mapper.insert("EstPedVdIt.incluirEstPedVdIt", json);
                this.mapper.commit();
                break;
            case 'PUT':
                this.mapper.update("EstPedVdIt.alterarEstPedVdIt", json);
                this.mapper.commit();
                break;
            case 'DELETE':
                this.mapper.update("EstPedVdIt.alterarEstPedVdIt", json);
                this.mapper.commit();
                break;
        }

    }catch(err){
        this.mapper.rollback();
        throw err;
    }

};
