/**
 * Created by Victor Vieira Garcia on 15/08/2017
 */
var PedidoDeCompra = function () {
    this.mapper = mapperFactory.createMapperMult(["VestPedCp"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();

};

/**
 * Metodo faz controle de geração de cartão
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */

PedidoDeCompra.prototype.buscaPedidoDeCompra = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        var resposta = {};
        var listaVestPedCp = this.mapper.selectList("VestPedCp.listarVestPedCp", {
            'cdPed': obj.get('cdPed'),
            'cdEmp': obj.get('cdEmp'),
            'cdFilial': obj.get('cdFilial')
        });

        var listaNotaFiscalPedido = this.mapper.selectList("VestPedCp.listarNotaFiscalPedido", {
            'cdPed': obj.get('cdPed'),
            'cdEmp': obj.get('cdEmp'),
            'cdFilial': obj.get('cdFilial')
        });

        if (listaVestPedCp.get(0).get('cdForn')) {
            var cdPedSol = this.mapper.selectOne("VestPedCp.cdPedSol", {
                'cdPed': obj.get('cdPed'),
                'cdEmp': obj.get('cdEmp'),
                'cdFilial': obj.get('cdFilial'),
                'cdForn': listaVestPedCp.get(0).get('cdForn')
            });
        }
        if (cdPedSol) {
            var cdGrpPed = this.mapper.selectOne("VestPedCp.cdGrpPed", {
                'cdPed': obj.get('cdPed'),
                'cdEmp': obj.get('cdEmp'),
                'cdPedSol': cdPedSol.get('cdPedSol')
            });
        }

        if (cdGrpPed) {
            var estAlcadaCpPed = this.mapper.selectOne("VestPedCp.estAlcadaCpPed", {
                'cdEmp': obj.get('cdEmp'),
                'cdGrpPed': cdGrpPed.get('cdGrpPed')
            });
        }

        resposta.listaVestPedCp = listaVestPedCp;
        resposta.listaNotaFiscalPedido = listaNotaFiscalPedido;
        resposta.estAlcadaCpPed = estAlcadaCpPed;

        this.mapper.commit();
        return resposta;
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        //gravaErro(itemValidado,err);
        throw err;
    }
};
/*GerenciarCartao.prototype.gerarCartao = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        var dadosSQL;
        var verificaClienteBloqueado = this.mapper.selectOne("RcCliConvRcCli.listarRcCliConvRcCli", { 'cdCli': json.get('cdCli'), 'cdEmp': json.get('cdEmp'), 'cdConv': json.get('cdConv') });
        if (verificaClienteBloqueado.get('stsCred') > 0) {
            return 'Solicitação cancelada, convenio bloqueado!';
        }

        var verificaCartaoSolicitado = this.mapper.selectList("RcCliFideliCartaoSolic.listarRcCliFideliCartaoSolic", { 'cdCli': json.get('cdCli'), 'cdEmp': json.get('cdEmp') });
        if (verificaCartaoSolicitado.size() > 0) {
            return 'Solicitação cancelada, cliente já contem solicitação aberta!';
        }

        var verificaPossuiCartao = this.mapper.selectList("RcCliFideliCartao.listarRcCliFideliCartao", { 'cdCli': json.get('cdCli') });
        if (verificaPossuiCartao.size() > 0) {
            //NÃO TEM PQ ATUALIZAR ESSES DADOS//
            this.mapper.update("RcCliFideliCartao.alterarRcCliFideliCartao", {
                'cdCli': json.get('cdCli'), 'cdEmp': json.get('cdEmp'), 'cdUsu': json.get('cdUsu')
            });
            dadosSQL = 'UPDATE - ' + { 'cdCli': json.get('cdCli'), 'cdEmp': json.get('cdEmp'), 'cdUsu': json.get('cdUsu') }
        } else {
            var lastNrCartao = this.mapper.selectOne("WebConvenio.maxFideliCartao", {});
            var nrBinEmp = this.mapper.selectOne("PrcEmp.listarPrcEmp", { 'cdEmp': json.get('cdEmp') });
            var objCartaoSolic = {
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'cdMot': 1,
                'datPrev': json.get('dataPrev'),
                'cdUsu': json.get('cdUsu'),
                'nrCartao': 0,
                'stsSolic': 0
            }

            var objCartao = {
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'stsCartao': 0,
                'nrControleCartao': lastNrCartao.get('nrControle'),
                'cdUsu': json.get('cdUsu'),
                'nrCartao': 0
            }
            if (nrBinEmp.get('nrBinCartao') > 0) {
                var nrBinCartao = nrBinEmp.get('nrBinCartao') + "" + java.lang.String.format("%010d", lastNrCartao.get('nrControle')) + "00";
                nrBinCartao += "" + this.modulo10(nrBinCartao);
                objCartaoSolic.nrCartao = nrBinCartao;
                objCartao.nrCartao = nrBinCartao;
                this.mapper.insert("RcCliFideliCartaoSolic.incluirRcCliFideliCartaoSolic", objCartaoSolic);
                this.mapper.insert("RcCliFideliCartao.incluirRcCliFideliCartao", objCartao);
                dadosSQL = 'POST - RcCliFideliCartaoSolic -' + this.jsonConvert.toJson(objCartaoSolic) + 'POST - RcCliFideliCartao - ' + this.jsonConvert.toJson(objCartao);
            } else {
                objCartaoSolic.nrCartao = lastNrCartao.get('nrControle');
                objCartao.nrCartao = lastNrCartao.get('nrControle');
                this.mapper.insert("RcCliFideliCartaoSolic.incluirRcCliFideliCartaoSolic", objCartaoSolic);
                this.mapper.insert("RcCliFideliCartao.incluirRcCliFideliCartao", objCartao);
                dadosSQL = 'POST - RcCliFideliCartaoSolic -' + this.jsonConvert.toJson(objCartaoSolic) + 'POST - RcCliFideliCartao - ' + this.jsonConvert.toJson(objCartao);
            }
        }
        var logSql = {
            cdUsu: json.get('cdUsu'),
            tpUsu: 0,
            cdConv: json.get('cdConv'),
            cdProc: 0,
            cdCli: json.get('cdCli'),
            tbSql: dadosSQL
        }

        this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);

        this.mapper.commit();
        return 'Cartão solicitado com sucesso!'
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        //gravaErro(itemValidado,err);
        throw err;
    }
};*/

