var ParametrosMediaF = function () {
    this.mapper = mapperFactory.createMapperMult(["EstParamComprasGrupoEstArvMercLinha", "EstParamComprasGrupoPrcFilial", "EstParamComprasGrupo", "EstParamComprasGrupoEstProd", "EstParamComprasGrupoEstArvMercCategoria", "EstParamComprasGrupoEstArvMercFamilia", "EstParamComprasGrupoEstMc", "EstParamComprasGrupoEstProdFabric", "EstProdCplMediap"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

ParametrosMediaF.prototype.post = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        for (var i = 0; i < obj.size(); i++) {
            var item = obj.get(i);
            if (item.get("filial") && item.get("filial").size() > 0) {

                for (var i = 0; i < item.get("filial").size(); i++) {
                    var itemFilial = item.get("filial").get(i);
                    this.vincularFilial(itemFilial);
                }
            }

            if (item.get("fabricante") && item.get("fabricante").size() > 0) {

                //this.mapper.insert("EstParamComprasGrupoEstProdFabric.excluirEstParamComprasGrupoEstProdFabric", {cdCtr: item.get("cdCtr"),cdEmp: item.get("cdEmp")});
                for (var i = 0; i < item.get("fabricante").size(); i++) {
                    var itemFabricante = item.get("fabricante").get(i);
                    this.vincularFabric(itemFabricante);
                }
            }

            if (item.get("linha") && item.get("linha").size() > 0) {

                for (var i = 0; i < item.get("linha").size(); i++) {
                    var itemLinha = item.get("linha").get(i);
                    this.vincularLinha(itemLinha);
                }

            }

            if (item.get("categoria") && item.get("categoria").size() > 0) {
                for (var i = 0; i < item.get("categoria").size(); i++) {
                    var itemCategoria = item.get("categoria").get(i);
                    this.vincularCategoria(itemCategoria);
                }

            }

            if (item.get("familia") && item.get("familia").size() > 0) {
                for (var i = 0; i < item.get("familia").size(); i++) {
                    var itemFamilia = item.get("familia").get(i);
                    this.vincularFamilia(itemFamilia);
                }

            }

            if (item.get("marca") && item.get("marca").size() > 0) {
                for (var i = 0; i < item.get("marca").size(); i++) {
                    var itemMarca = item.get("marca").get(i);
                    this.vincularMarca(itemMarca);
                }

            }

            if (item.get("produto") && item.get("produto").size() > 0) {
                for (var i = 0; i < item.get("produto").size(); i++) {
                    var itemProduto = item.get("produto").get(i);
                    this.vincularProduto(itemProduto);
                }

            }

        }
        this.mapper.commit();
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }

};

ParametrosMediaF.prototype.listarMediaPeQmax = function (json) {
    try {
        var arr = json.get("arrayList");
        var cdFilial = [];
        var result = [];
        for (var i = 0; i < arr.size(); i++) {
            if (cdFilial.indexOf(parseInt(arr.get(i).get("cdFilial"))) == -1) {
                cdFilial.push(parseInt(arr.get(i).get("cdFilial")));
            }
        }

        for (var f = 0; f < cdFilial.length; f++) {
            var response = {
                "cdFilial": 0,
                "cdProdutos": 0,
                "result": 0
            };
            var objMap = mapperFactory.createMap();
            objMap.put("cdFilial", 0);
            objMap.put("listCdProdutos", []);
            objMap.put("emax", 0);
            objMap.put("qtdeMediap", 0);

            for (var j = 0; j < arr.size(); j++) {
                if (parseInt(arr.get(j).get("cdFilial")) == parseInt(cdFilial[f])) {
                    objMap.put("cdFilial", parseInt(arr.get(j).get("cdFilial")));
                    objMap.get("listCdProdutos")[objMap.get("listCdProdutos").length] = parseInt(arr.get(j).get("cdProd"));
                    objMap.put("emax", arr.get(j).get("emax"));
                    objMap.put("qtdeMediap", arr.get(j).get("novaMediap"));
                }
            }

            response.cdFilial = objMap.get("cdFilial");
            response.cdProdutos = objMap.get("listCdProdutos");
            response.result = this.mapper.selectList("EstProdCplMediap.listarMediaPeQmax", objMap);
            result[f] = response;

        }
        // java.lang.System.out.println("FIM   " + this.jsonConvert.toJson(result));
        this.mapper.commit();
        return result;
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

ParametrosMediaF.prototype.listarMediaPeQmaxEspelhamento = function (produtos, filialDestino) {
    try {

        for (var i = 0; i < produtos.size(); i++) {
            let novosValores = this.mapper.selectList("EstProdCplMediap.listarMediaPeQmax", {"cdFilial": filialDestino, "qtdeMediap": produtos.get(i).get("novaMediap"), "listCdProdutos": [produtos.get(i).get("cdProd")]});
            if(novosValores.size() > 0 ){
                produtos.get(i).put('qMax', novosValores.get(0).get('qEmax'));
                produtos.get(i).put('qSeg', novosValores.get(0).get('qEseg'));
                produtos.get(i).put('dsSigla', novosValores.get(0).get('dsSigla'));
            }
        }

        return produtos;
    } catch (err) {
        throw err;
    }
};

ParametrosMediaF.prototype.vincularFilial = function (json) {
    this.mapper.insert('EstParamComprasGrupoPrcFilial.incluirEstParamComprasGrupoPrcFilial', json);

};

ParametrosMediaF.prototype.vincularFabric = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstProdFabric.incluirEstParamComprasGrupoEstProdFabric', json);
};

ParametrosMediaF.prototype.vincularLinha = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstArvMercLinha.incluirEstParamComprasGrupoEstArvMercLinha', json);
};

ParametrosMediaF.prototype.vincularProduto = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstProd.incluirEstParamComprasGrupoEstProd', json);
};

ParametrosMediaF.prototype.vincularMarca = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstMc.incluirEstParamComprasGrupoEstMc', json);
};

ParametrosMediaF.prototype.vincularFamilia = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstArvMercFamilia.incluirEstParamComprasGrupoEstArvMercFamilia', json);
};

ParametrosMediaF.prototype.vincularCategoria = function (json) {
    this.mapper.insert('EstParamComprasGrupoEstArvMercCategoria.incluirEstParamComprasGrupoEstArvMercCategoria', json);
};