/**
 * Created by willian batista on 01/11/16.
 */
var IntegracaoFornecedorFtp = function() {
    this.mapper = mapperFactory.createMapperMult(["PgFornIntegracao", "PgFornIntegracaoArqPendente"]);
};

IntegracaoFornecedorFtp.prototype.ajustarDadosParaPersistencia = function(json){
	if(json.get("endInt") === null)
		json.put("endInt", '');
	if(json.get("usuInt") === null)
		json.put("usuInt", '');
	if(json.get("senhaInt") === null)
		json.put("senhaInt", '');
	if(json.get("enviaEmail") === null)
		json.put("enviaEmail", '');
	if(json.get("tamanhoPctEnvio") === null)
		json.put("tamanhoPctEnvio", 20);
	else
		json.put("tamanhoPctEnvio", json.get("tamanhoPctEnvio"));
};
  
/**
 * Metodo realiza insert na tabela PG_FORN_INTEGRACAO
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
IntegracaoFornecedorFtp.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.ajustarDadosParaPersistencia(json);
		this.mapper.insert('PgFornIntegracao.incluirPgFornIntegracao', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo realiza update na tabela PG_FORN_INTEGRACAO, 
 * se e somente se não haja arquivos pendente de retorno do fornecedor
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
IntegracaoFornecedorFtp.prototype.put = function(json){
  		if(json === null || json.size() === 0){
  			 throw {code: 599, message: "Dados passados ao servidor inválido!"};
  		}
  		
  		/*this.validarSeTemArquivoPendenteParaIntegracao(json);*/
  		
  		try{
  			this.ajustarDadosParaPersistencia(json);
  			this.mapper.update('PgFornIntegracao.alterarPgFornIntegracao', json);
  			this.mapper.commit();
  		}catch(err){
  			this.mapper.rollback();
  			throw err;
  		}
  		
};

/**
 * Metodo realiza delete na tabela PG_FORN_INTEGRACAO, 
 * se e somente se não haja vinculo com a tabela de arquivo PG_FORN_INTEGRACAO_ARQ_PENDENTE
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
IntegracaoFornecedorFtp.prototype.del = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	this.validarSeTemVinculoComArquivoDeIntegracao(json);
	
	try{
		this.mapper.update('PgFornIntegracao.excluirPgFornIntegracao', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo realiza busca dos arquivos pendentes de retorno para a integração do fornecedor
 * tabela de vinculo é a PG_FORN_INTEGRACAO_ARQ_PENDENTE
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throw {Exception} Caso haja vinculo arquivos pendentes de retorno para a integração
 */
IntegracaoFornecedorFtp.prototype.validarSeTemArquivoPendenteParaIntegracao = function(json){
	var arquivosPendentesDeIntegracao = this.mapper.selectList("PgFornIntegracaoArqPendente.listarArquivosPendentesPorIntegracao", json);
	if(arquivosPendentesDeIntegracao.size()>0){
		throw {code: 599, message: 'Não é possivel alterar integração, integração possui arquivos pendentes!'};
	}
};


/**
* Metodo válida se há arquivos vinculados com a integração do fornecedor
* tabela de vinculo é a PG_FORN_INTEGRACAO_ARQ_PENDENTE
* @param {HashMap JAVA} json - parametro passado no momento da requisicao
* @throws {{Exception}}
*/
IntegracaoFornecedorFtp.prototype.validarSeTemVinculoComArquivoDeIntegracao = function(json){
	var arquivosDeIntegracao = this.mapper.selectList("PgFornIntegracaoArqPendente.listarPgFornIntegracaoArqPendente", {"cdEmp": json.get("cdEmp"), "cdForn": json.get("cdForn"), "cdInt": json.get("cdInt")});
	if(arquivosDeIntegracao.size()>0){
		throw {code: 599, message: 'Não é possivel excluir integração, pois possui vinculo com arquivos de integração!'};
	}
};


/**
* Metodo retorna um array com somatorios do arquivos pendentes de envio,
* retorno e processamento respectivamentes
* @returns {ArrayLsit JAVA}
*/
IntegracaoFornecedorFtp.prototype.validarSeTemVinculoComArquivoDeIntegracao = function(){
	
};