load( "/rules/filial/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
load( "/model/cliente/insereRegistro.js" );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Filial = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "PrcFilial", "PrcFilialRcCli", "PrcFilialPgForn","PrcFilialNfSeries" ]);
	this.validaFilial = new ValidaFilial();
	this.cliente = new Cliente( );
	this.gravaErro = new AdmErroIntegracoes( );
	this.jsonConvert = new com.google.gson.GsonBuilder( ).create( );
	this.i = 0;
};

/**
 * Metodo faz controle das inserções de familia a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Filial.prototype.insereFilial = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
		var importacao = true;
		
	} else {
		var obj = mapperFactory.createMap( );
		var importacao = false;
		obj.put( 0, json );
		
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item = obj.get( this.i );
			var itemValidado = this.validaFilial.validaDadosParaCadastro( item );

			this.mapper.insert( "PrcFilial.incluirPrcFilial", itemValidado );

			if ( itemValidado.get( "importador" ) > 0 ) {
                var novoCliente = this.insereFilialComoCliente( item );
                itemValidado.put("cliente",novoCliente);
            }

			var messageetoVinculoRequest = new java.util.HashMap( );
			messageetoVinculoRequest.put("cdEmp", itemValidado.get( "cdEmp" ));
			messageetoVinculoRequest.put("cdFilial", itemValidado.get( "cdFilial" ));

			if ( itemValidado.get( "cliente" ).get( "cdCli" ) != null ) {
				messageetoVinculoRequest.put("cdCli", itemValidado.get( "cliente" ).get( "cdCli" ));
				this.mapper.insert( "PrcFilialRcCli.incluirPrcFilialRcCli", messageetoVinculoRequest );
			}

			if ( itemValidado.get( "fornecedor" ).get( "cdForn" ) != null ) {
				messageetoVinculoRequest.put("cdForn", itemValidado.get( "fornecedor" ).get( "cdForn" ));
				this.mapper.insert( "PrcFilialPgForn.incluirPrcFilialPgForn", messageetoVinculoRequest );
			}

			if(itemValidado.get("series") != null){
				this.mapper.update("PrcFilialNfSeries.excluirPrcFilialNfSeries", {"cdEmp":itemValidado.get("cdEmp"), "cdFilial": itemValidado.get("cdFilial")});
				if(itemValidado.get("series").size() > 0)
					this.mapper.insert("PrcFilialNfSeries.incluirPrcFilialNfSeriesEmLote", {"cdEmp":itemValidado.get("cdEmp"), "cdFilial": itemValidado.get("cdFilial"), "series":itemValidado.get("series")});
			}

		}

		this.mapper.commit();
		
		if(importacao)
			return obj;
		else
			return obj.get(0);
		

	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		throw err;
	}
};

/**
  * Metodo faz controle das inserções do cliente que representa o convenio
  * @param {HashMap JAVA} json - parametro passado no momento da requisicao
  * @throws {InvalidArgumentException}
  * @return retorna o codigo do cliente que representa a filial caso esse exista, caso o parametro importador for maior que 0 ira realizar o cadastro de um novo cliente e retornara o codigo deste
  */

Filial.prototype.insereFilialComoCliente = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
  if(json.get("cgcCpf") && json.get("cgcCpf").length() >= 11 ){
      var variaveis = {};
      variaveis.cgcCpf = json.get("cgcCpf");
      cliente = this.mapper.selectOne( "RcCli.listarRcCli", variaveis );
      if ( cliente ) {
        return cliente.get("cdCli");
      }else{
          if ( parseInt(json.get( "importador" )) > 0 ) {
             var novoCliente = this.insereCliente(json);
             return novoCliente.get(0);
          }
      }
  }else {
      if ( parseInt(json.get( "importador" )) > 0 ) {
        var novoCliente = this.insereCliente(json);
        return novoCliente.get(0);
      }
  }


};

/**
  * Metodo faz a chamada do serviço que faz inserção do cliente que representa a filial
  * @param {HashMap JAVA} json - parametro passado no momento da requisicao
  *@return retorna o objeto do cliente que foi inserido
  */

 Filial.prototype.insereCliente = function( json ) {
	var variaveis = mapperFactory.createMap( );
	variaveis.put("cgcCpf", json.get( "cgc" ));
	variaveis.put("rzCli", json.get( "rzFilial" ));
	variaveis.put("nmFant", json.get( "nmFant" ));
	variaveis.put("pessoa", 1 );
	variaveis.put("endCli", json.get( "endFilial" ));
	variaveis.put("bairro", json.get( "bairro" ));
	variaveis.put("cdCid", json.get( "cdCid" ));
	variaveis.put("cdUsu", 1 );
	variaveis.put("espCli", 0 );
	variaveis.put("cdTpCli", 2 );
	variaveis.put("cep", json.get( "cep" ));
	today = new Date( );
	dd = today.getDate( );
	mm = today.getMonth( ) + 1; //January is 0!
	yyyy = today.getFullYear( );
	if ( dd < 10 ) {
		dd = '0' + dd;
	}
	if ( mm < 10 ) {
		mm = '0' + mm;
	}
	hoje = yyyy + '/' + mm + '/' + dd;
	variaveis.put( "dtNasc", hoje );

	var novoCliente = this.cliente.insereRegistro( variaveis );
	return novoCliente.get( 0 );
};
