load("/rules/convenio/validaDados.js");
load('/model/erro/admErroCadBasicosIntegracoes.js');
load("/model/cliente/insereRegistro.js");
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Convenio = function () {
	this.mapper = mapperFactory.createMapperMult(["RcCliConv", "RcCli", "RcCliConvVincRcCli", "RcCliConvAudit"]);
	this.validaDados = new ValidaConvenio();
	this.gravaErro = new AdmErroIntegracoes();
	this.jsonConvert = new com.google.gson.GsonBuilder().create();
	this.cliente = new Cliente();
	this.i = 0;
};

/**
 * Metodo faz controle das inserções a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Convenio.prototype.insereRegistro = function (json) {
	if (!json) {
		throw {
			code: 599,
			message: "Dados passados ao servidor inválido!"
		};
	}
	if (json.get("obj")) {
		var obj = json.get("obj");
	} else {
		var obj = mapperFactory.createMap();
		obj.put(0, json);
	}

	try {
		for (this.i = 0; this.i < obj.size(); this.i++) {
			var item = obj.get(this.i);
			var isCadastrado = this.validaDados.isCadastrado(json);
			if (isCadastrado === true) {
				throw {
					code: 599,
					message: "Convenio " + json.get("cdConv") + " Já Cadastrado"
				};
			}
			if (item.get(!cdCli) || item.get(cdCli) === null || item.get(cdCli) === undefined) {
				var cdCli = this.insereClienteConvenio(item);
			}
			var itemValidado = this.validaDados.dadosDefault(item);
			if (cdCli) {
				itemValidado.put("cdCli", cdCli);
			}
			this.insereConvenio(itemValidado);

			if (itemValidado.get("cliente")) {
				this.atualizaCliente(itemValidado.get("cliente"));
			}
			if (itemValidado.get("importador") == 1) {
				this.gravaSucesso(itemValidado);
			}
		}
		this.mapper.commit();
		if (obj.size() == 1) {
			return obj.get(0).get("cdConv");
		} else {
			return obj;
		}
		return 
	} catch (err) {
		java.lang.System.out.println(err);
		this.mapper.rollback();
		//gravaErro(itemValidado,err);
		throw err;

	}
};

Convenio.prototype.atualizaConvenio = function (json) {
	if (!json) {
		throw {
			code: 599,
			message: "Dados passados ao servidor inválido!"
		};
	}
	if (json.get("obj")) {
		var obj = json.get("obj");
	} else {
		var obj = mapperFactory.createMap();
		obj.put(0, json);
	}

	try {
		for (this.i = 0; this.i < obj.size(); this.i++) {
			var item = obj.get(this.i);
			//java.lang.System.out.println('item ' + this.jsonConvert.toJson(item));	
			var itemValidado = this.validaDados.dadosDefault(item);
		
			if (itemValidado.get("cliente")) {
				this.atualizaCliente(itemValidado.get("cliente"));
			}

			this.mapper.update("RcCliConv.alterarRcCliConv", itemValidado);
			this.insereAuditoria(itemValidado);
		}
		this.mapper.commit();
		if (obj.size() == 1) {
			obj.get(0).get("cdConv");
		} else {
			obj;
		}
	} catch (err) {
		java.lang.System.out.println(err);
		this.mapper.rollback();
		//gravaErro(itemValidado,err);
		throw err;

	}
};

Convenio.prototype.gravaSucesso = function (json) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = parseInt(json.get("cdConv"));
	msgErro.tabela = 'RC_CLI_CONV';
	msgErro.jsonEnviado = this.jsonConvert.toJson(json);
	msgErro.stsErro = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = 'Convenio ' + json.get("cdConv") + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro(metodo, msgErro);
};

Convenio.prototype.gravaErro = function (json) {
	java.lang.System.out.println('itemValidado ' + itemValidado);
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get("cdConv") || 0;
	msgErro.tabela = 'RC_CLI_CONV';
	msgErro.jsonEnviado = this.jsonConvert.toJson(json);
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson(err);
	this.gravaErro.gerenciaErro(metodo, msgErro);
};

/**
 * Metodo faz controle das inserções do cliente que representa o convenio
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna o codigo do cliente que administra o convenio caso esse exista, caso o parametro importador for
 *maior que 0 ira realizar o cadastro de um novo cliente e retornara o codigo deste
 */
Convenio.prototype.insereClienteConvenio = function (json) {
	if (!json) {
		throw {
			code: 599,
			message: "Dados passados ao servidor inválido!"
		};
	}
	if (json.get("cgcCpf") && json.get("cgcCpf").length() >= 11) {
		var variaveis = {};
		variaveis.cgcCpf = json.get("cgcCpf");
		cliente = this.mapper.selectOne("RcCli.listarRcCli", variaveis);
		if (cliente) {
			return cliente.get("cdCli");
		} else {
			if (parseInt(json.get("importador")) > 0) {
				var novoCliente = this.insereCliente(json);
				return novoCliente;
			}
		}
	} else {
		if (parseInt(json.get("importador")) > 0) {
			var novoCliente = this.insereCliente(json);
			return novoCliente;
		}
	}

};

/**
 * Metodo faz inserção do convenio
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 */
Convenio.prototype.insereConvenio = function (json) {
	this.mapper.insert("RcCliConv.incluirRcCliConv", json);
};

Convenio.prototype.insereAuditoria = function (json) {
	this.mapper.insert("RcCliConvAudit.incluirRcCliConvAudit", json);
};

Convenio.prototype.atualizaCliente = function (json) {
	this.mapper.update("RcCli.alterarRcCli", json);
	this.mapper.update("RcCliConvVincRcCli.alterarRcCliConvVincRcCli", json);
};

/**
 * Metodo faz a chamada do serviço que faz a inserção do cliente que representa o convenio
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 *@return retorna o objeto do cliente que foi inserido
 */
Convenio.prototype.insereCliente = function (json) {
	var variaveis = mapperFactory.createMap();
	variaveis.put("cgcCpf", json.get("cgcCpf"));
	variaveis.put("rzCli", json.get("dsConv"));
	variaveis.put("nmFant", json.get("nmFant"));
	variaveis.put("pessoa", 1);
	variaveis.put("endCli", json.get("endCli"));
	variaveis.put("bairro", json.get("bairro"));
	variaveis.put("cdCid", json.get("cdCid"));
	variaveis.put("cdUsu", 1);
	variaveis.put("espCli", 0);
	variaveis.put("cdTpCli", 2);
	variaveis.put("cep", json.get("cep"));
	today = new Date();
	dd = today.getDate();
	mm = today.getMonth() + 1; //January is 0!
	yyyy = today.getFullYear();
	if (dd < 10) {
		dd = '0' + dd;
	}
	if (mm < 10) {
		mm = '0' + mm;
	}
	hoje = yyyy + '/' + mm + '/' + dd;
	variaveis.put("dtNasc", hoje);

	var novoCliente = this.cliente.insereRegistro(variaveis);
	return novoCliente;
};