/**
 * Created by willian batista on 07/12/16.
 */
var RoteiroDeCompra = function() {
    this.mapper = mapperFactory.createMapperMult(["EstPedCpRoteiroCp", "EstPedEltrAtivaCpEstPedCpRoteiroCp", "EstPedCpRoteiroCpEstPedCpParam", "EstPedCpRoteiroCpAgdSemana"]);
};


/**
 * Metodo realiza parse dos dados do agendamento do roteiro para serem persistido no banco
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
var parseDadosAgendamentoParaPersistencia = function(json){
	var listaDeItensDaAgenda = [];
	
	if(json.get("domingo") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":1});
	}
	if(json.get("segunda") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":2});
	}
	if(json.get("terca") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":3});
	}
	if(json.get("quarta") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":4});
	}
	if(json.get("quinta") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":5});
	}
	if(json.get("sexta") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":6});
	}
	if(json.get("sabado") == true){
		listaDeItensDaAgenda.push({"cdRoteiro":json.get("cdRoteiro"), "cdDia":7});
	}
	
	return listaDeItensDaAgenda;

};


/**
 * Metodo realiza inserção na tabela EST_PED_CP_ROTEIRO_CP e vincula
 * as data de agendamento da semana na tabela EST_PED_CP_ROTEIRO_CP_AGD_SEMANA
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
RoteiroDeCompra.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	 	
	try{
		this.mapper.insert('EstPedCpRoteiroCp.incluirEstPedCpRoteiroCp', json);
		var dadosDeAgendamento = parseDadosAgendamentoParaPersistencia(json);
		if(dadosDeAgendamento.length>0){
		    this.mapper.insert('EstPedCpRoteiroCpAgdSemana.incluirAgendaDoRoteiro', {"inserir":dadosDeAgendamento});
		}
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo realiza o update na tabela EST_PED_CP_ROTEIRO_CP e vincula
 * as data de agendamento da semana na tabela EST_PED_CP_ROTEIRO_CP_AGD_SEMANA
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
RoteiroDeCompra.prototype.put = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.mapper.update('EstPedCpRoteiroCp.alterarEstPedCpRoteiroCp', json);
		var dadosDeAgendamento = parseDadosAgendamentoParaPersistencia(json);
		//remove agendamento para o roteiro na tabela
		this.mapper.update('EstPedCpRoteiroCpAgdSemana.excluirEstPedCpRoteiroCpAgdSemana',{"cdRoteiro":json.get("cdRoteiro")});
		//remonta o agendamento do roteiro
		if(dadosDeAgendamento.length>0){
		    this.mapper.insert('EstPedCpRoteiroCpAgdSemana.incluirAgendaDoRoteiro', {"inserir":dadosDeAgendamento});
		}
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo realiza o delete na tabela EST_PED_CP_ROTEIRO_CP se e somente se,
 * não houver vinculo de ativação de demanda com tal roteiro
 * @param {Object JS} objeto javascript com o atributo cdRoteiro (codigo do roteiro)
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
RoteiroDeCompra.prototype.del = function(codigoDoRoteiro){
	if(codigoDoRoteiro === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	var vinculoComAtivacaoDeCompra =  this.mapper.selectList('EstPedEltrAtivaCpEstPedCpRoteiroCp.listarEstPedEltrAtivaCpEstPedCpRoteiroCp', codigoDoRoteiro);
	
	if(vinculoComAtivacaoDeCompra.size() > 0 ){
		 throw {code: 599, message: "Roteiro não pode ser excluido, existe ativação de demanda para o mesmo!"};
		 
	}else{
		
		try{
			this.mapper.update('EstPedCpRoteiroCp.excluirEstPedCpRoteiroCp', codigoDoRoteiro);
			this.mapper.update('EstPedCpRoteiroCpEstPedCpParam.excluirEstPedCpRoteiroCpEstPedCpParam', codigoDoRoteiro);
			this.mapper.update('EstPedCpRoteiroCpAgdSemana.excluirEstPedCpRoteiroCpAgdSemana', codigoDoRoteiro);
			this.mapper.commit();
		}catch(err){
			this.mapper.rollback();
			throw err;
		}
		
	}
};