/**
 * Created by Victor vieira on 07/03/2017.
 */
var PerfilFilialProduto = function () {
	this.mapper = mapperFactory.createMapperMult(["EstParamComprasPerfilEstProd", "EstParamComprasPerfilPrcFilial", "EstParamComprasPerfilTamanho", "EstParamComprasPerfilDemografico"]);
	this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

/**
 * Metodo para validar se possui produto com parametros já cadastrado
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */

PerfilFilialProduto.prototype.post = function (json) {
	try {
		let listaDeEntradaDeProdutos = json.get("lisProdutos");
		let listaDeEntradaDePerfis = json.get("listPerfil");
		let cabecalho = json.get("cabecalho");
		var listProdutos = [];
		var listPerfis = [];

		this.mapper.insert("EstParamComprasPerfilEstProd.incluirEstParamComprasPerfilLoteTransacao", cabecalho);
		var cdCtr = cabecalho.get("cdCtr");

		var contador = 0;
		var numParametroInsert = 3;
		while (true) {

			listaDeEntradaDeProdutos.get(contador).put('cdCtr', cdCtr);
			listaDeEntradaDeProdutos.get(contador).put("cdEmp", 1);
			listProdutos.push(listaDeEntradaDeProdutos.get(contador));

			if ((contador + 1) %~~(2000 / numParametroInsert) == 0) {
				this.mapper.insert("EstParamComprasPerfilEstProd.incluirEstParamComprasPerfilLoteTransacaoEstProd", {
					'perfis': listProdutos
				});
				listProdutos = [];
			}

			if ((contador + 1) == listaDeEntradaDeProdutos.size() && listProdutos.length > 0) {

				this.mapper.insert("EstParamComprasPerfilEstProd.incluirEstParamComprasPerfilLoteTransacaoEstProd", {
					'perfis': listProdutos
				});
				listProdutos = [];
				break;
			} else if ((contador + 1) == listaDeEntradaDeProdutos.size() && listProdutos.length == 0) {
				break;
			}

			contador++;
		}


		for (var j = 0; j < listaDeEntradaDePerfis.size(); j++) {
			listaDeEntradaDePerfis.get(j).put("cdCtr", cdCtr);
			listPerfis.push(listaDeEntradaDePerfis.get(j));
		}

		var perfis = {
			"perfis": listPerfis
		};

		this.mapper.insert("EstParamComprasPerfilEstProd.incluirEstParamComprasPerfilLoteTransacaoPerfil", perfis);

		//this.mapper.selectList("EstParamComprasPerfilEstProd.execParamComprasPerfilEstProdAplicar", {'cdCtr': cdCtr});

		this.mapper.commit();
		return json;

	} catch (err) {
		this.mapper.rollback();
		throw err;
	}
};

PerfilFilialProduto.prototype.postFilial = function (json) {
	try {

		let listCdFilial = json.get("listFilial");
		let cabecalho = json.get("cabecalho");
		var listPerfis = [];

		for (var i = 0; i < listCdFilial.size(); i++) {
			var td = listCdFilial.get(i).get('cdPerfilTamanho') + listCdFilial.get(i).get('cdPerfilTamanho');
			var tamanho = listCdFilial.get(i).get('cdPerfilTamanho');
			var demografico = listCdFilial.get(i).get('cdPerfilDemografico');
			var cdFilial = [];

			if (listPerfis.indexOf(td) == -1) {
				listPerfis.push(td);
				this.mapper.insert("EstParamComprasPerfilEstProd.incluirEstParamComprasPerfilLoteTransacao", cabecalho);
				var cdCtr = cabecalho.get("cdCtr");

				for (var j = 0; j < listCdFilial.size(); j++) {
					if (listCdFilial.get(j).get('cdPerfilTamanho') == tamanho && listCdFilial.get(j).get('cdPerfilDemografico') == demografico) {
						cdFilial.push(listCdFilial.get(j).get('cdFilial'));
					}
				}

				var listFiliais = {
					"cdEmp": listCdFilial.get(i).get('cdEmp'),
					"cdCtr": cdCtr,
					"filiais": cdFilial
				};

				java.lang.System.out.println("LISTFILIAIS----  " + this.jsonConvert.toJson(listFiliais));
				this.mapper.insert("EstParamComprasPerfilPrcFilial.incluirEstParamComprasPerfilLoteTransacaoPrcFilial", listFiliais);
				var perfil = {
					"cdCtr": cdCtr,
					"cdPerfilTamanho": tamanho,
					"cdPerfilDemografico": demografico
				}
				this.mapper.insert("EstParamComprasPerfilPrcFilial.incluirEstParamComprasPerfilLoteTransacaoPerfil", perfil);
				this.mapper.selectList("EstParamComprasPerfilPrcFilial.execParamComprasPerfilEstProdAplicar", {
					'cdCtr': cdCtr
				});
			}
		}

		this.mapper.commit();
		return json;

	} catch (err) {
		this.mapper.rollback();
		throw err;
	}
};

PerfilFilialProduto.prototype.removerVinculos = function (json) {
	try {
		let param = {
			'itens': [],
			'cdEmp': json.get('cdEmp'),
			'cdUsu': json.get('cdUsu')
		};
		let numMarkers = 0;

		for (let i = 0; i < json.get('itens').size(); i++) {
			let item = json.get('itens').get(i);
			if (numMarkers + 2 > 2000) {

				this.mapper.update('EstParamComprasPerfilEstProd.removerVinculos', param);
				param.itens = [];
				numMarkers = 0;
				i--;
			} else {
				param.itens.push(item);
				numMarkers = numMarkers + 2;
			}
		}

		if (param.itens.length > 0)
			this.mapper.update('EstParamComprasPerfilEstProd.removerVinculos', param);

		this.mapper.commit();

	} catch (err) {
		this.mapper.rollback();
		throw err;
	}
};