/**
 * Created by willian batista on 30/11/16.
 */
var ParametrosDeCompra = function() {
    this.mapper = mapperFactory.createMapperMult(["EstPedCpParam", "EstPedCpParamPrcFilial"]);
};

/**
 * Metodo realiza insert na tabela EST_PED_CP_PARAM
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
ParametrosDeCompra.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.mapper.insert('EstPedCpParam.incluirEstPedCpParam', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo realiza update na tabela EST_PED_CP_PARAM,
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
ParametrosDeCompra.prototype.put = function(json){
  		if(json === null || json.size() === 0){
  			 throw {code: 599, message: "Dados passados ao servidor inválido!"};
  		}
  		
  		try{
  			this.mapper.update('EstPedCpParam.alterarEstPedCpParam', json);
  			this.mapper.commit();
  		}catch(err){
  			this.mapper.rollback();
  			throw err;
  		}
  		
};



/**
 * Metodo realiza atualização dos vinculos das filiais na EST_PED_CP_PARAM_PRC_FILIAL,
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
ParametrosDeCompra.prototype.atualizarVinculoDeFiliais = function(json){
  		if(json === null || json.size() === 0){
  			 throw {code: 599, message: "Dados passados ao servidor inválido!"};
  		}
  		
  		try{
  			if(json.get('inserir').size() > 0)
  				this.mapper.insert("EstPedCpParamPrcFilial.incluirVinculosEmMassa", json);
  			
  			if(json.get('remover').size() > 0)
  				this.mapper.insert("EstPedCpParamPrcFilial.excluirVinculosEmMassa", json);
  			
  			this.put(json);
  				
  			this.mapper.commit();
  			return {'filiais': this.mapper.selectList('EstPedCpParamPrcFilial.listatVinculosDeFiliaisDoParametroDeCompra', {'cdEmp':json.get("cdEmp"), 'cdPedCpParam':json.get("cdPedCpParam")} )};
  		}catch(err){
  			this.mapper.rollback();
  			throw err;
  		}
  		
};

